Retskrivningsregler
===================

§ 1-6. Bogstaver og tegn {#bogstaver-og-tegn xmlns="http://www.w3.org/1999/xhtml" h="http://www.w3.org/1999/xhtml"}
========================

### § 1. Bogstaverne

#### (1) Alfabetet

Det danske alfabet består af 29 bogstaver. Hvert af bogstaverne findes
både som lille bogstav og som stort bogstav:

a b c d e f g h i j k l m n o p q r s t u v w x y z æ ø å\
A B C D E F G H I J K L M N O P Q R S T U V W X Y Z Æ Ø Å.

Om brugen af store og små bogstaver, se § 11-14.

#### (2) Fremmede bogstaver

I proprier og i ord der citeres fra andre sprog, kan der forekomme andre
bogstaver, fx Ü/ü, Ä/ä, Ö/ö, Ð/ð, Þ/þ. -- Om sådanne bogstavers
placering i alfabetet, se § 4.3.

### § 2. Tegn

#### (1) Almindelige tegn

I almindelige danske ord og tekster bruges følgende tegn (accenter og
interpunktionstegn):

  ----- -------------------------------------------------------------
  ´     accenttegn (accent aigu, § 5)
  '     apostrof (§ 6)
  .     punktum (§ 41-43)
  ;     semikolon (§ 44)
  ,     komma (§ 45-51)
  :     kolon (§ 52)
  ?     spørgsmålstegn (§ 53)
  !     udråbstegn (§ 54)
  --    tankestreg (§ 55) og replikstreg (§ 59)
  ( )   parentes (§ 56)
  \-    bindestreg (§ 57)
  » «   anførselstegn (kan også have andre former, se nærmere § 58)
  /     skråstreg (§ 60)
  ----- -------------------------------------------------------------

#### (2) Særlige tegn

Desuden forekommer der en række andre accenter og interpunktionstegn,
især i proprier og i ord og tekster der citeres fra andre sprog, samt i
mere tekniske eller faglige tekster, fx

  ------- ----------------------------------
  \`      accent grave
  ¸       cedille
  \^      cirkumfleks (accent circonflexe)
  ¨       trema
  \~      tilde
  \[ \]   kantet parentes (skarp parentes)
  ------- ----------------------------------

### § 3. *Å* og dobbelt-*a*

Bogstavet Å/å blev med Undervisningsministeriets bekendtgørelse af
22.3.1948 indført til erstatning af Aa/aa (dobbelt-a) som betegnelse for
en å-lyd. I den nugældende retskrivning er å enerådende i sprogets
almindelige ord (se nærmere i § 3.1 nedenfor), mens aa stadig har en vis
udbredelse i stednavne (§ 3.2) og i personnavne (§ 3.3).

#### (1) Almindelige ord

I sprogets almindelige ord, dvs. de ord der ikke er proprier, skrives
der altid å og ikke aa som betegnelse for en å-lyd:

> åben, ål, år, tå, tåler, påstå, småål.

Afledninger til og sammensætninger med navne der lokalt ønskes skrevet
med aa (se § 3.2), kan dog også skrives med aa. I selve ordbogen er
sådanne ord opført som dobbeltformer, fx

ål\|bor\|gen\|ser (el. aalborgenser) sb., -en, -e, -ne (jf. § 3.1)\
\
aal\|bor\|gen\|ser (el. ålborgenser) sb., -en, -e, -ne (jf. § 3.1)

I nogle ord er bogstavforbindelsen aa den eneste mulighed. Den betegner
dog i sådanne tilfælde ikke en å-lyd, men en eller flere a-lyde:
afrikaans, kanaanæer, ekstraarbejder.

I ordet krål/kraal, som kan udtales enten med å-lyd eller med a-lyd, kan
man valgfrit skrive å eller aa.

#### (2) Stednavne

Det er altid korrekt at skrive danske stednavne med å: Åbenrå, Ålborg,
Århus, Fåborg, Grenå, Tåsinge, Tåstrup.

En del lokale myndigheder foretrækker imidlertid skrivemåderne med aa,
fx Aabenraa, Aalborg, Aarhus, Grenaa, og disse ønsker fremgår af
Stednavneudvalgets liste over autoriserede danske stednavne. I de
tilfælde hvor sådanne stednavne er medtaget i Retskrivningsordbogen, er
navnene opført som dobbeltformer, fx

Gren\|å (el. Grenaa) prop. (jf. § 3.2)\
\
Gren\|aa (el. Grenå) prop. (jf. § 3.2)

Om muligheden for at bruge aa i afledninger til og sammensætninger med
sådanne navne, se § 3.1.

I stednavne på norsk og svensk skal der altid skrives å og ikke aa som
betegnelse for en å-lyd: Ålesund, Åbo, Borås, Skåne. Bogstavforbindelsen
aa kan forekomme i udenlandske stednavne, men betegner i sådanne
tilfælde ikke en å-lyd, men en eller flere a-lyde:

> Aachen, Dar-es-Salaam, Kanaan, Kirunavaara, Maastricht, Saar.

#### (3) Personnavne

I personnavne forekommer både å og aa som betegnelse for en å-lyd. Man
kan dog ikke veksle frit mellem skrivemåder som fx Åse og Aase og
Vestergård og Vestergaard, men bør skrive sådanne personnavne på samme
måde som den enkelte bærer af navnet selv skriver dem.

Om brugen af å og aa i navne på firmaer, foreninger o.l., se § 61.3.b.

### § 4. Alfabetisk rækkefølge

#### (1) De almindelige bogstaver

Rækkefølgen af de almindelige bogstaver fremgår af alfabetet i § 1. Hvis
den eneste forskel på to ord er at det ene skrives med stort
begyndelsesbogstav og det andet med lille begyndelsesbogstav, kommer
formen med stort begyndelsesbogstav først, fx Karl -- karl.

#### (2) Placeringen af *aa*

Når bogstavforbindelsen aa udtales som én vokal, alfabetiseres den som å
uanset om den betegner en a-lyd eller en å-lyd. Hvis den eneste forskel
på to ordformer er at den ene skrives med å og den anden med aa, kommer
formen med å først, fx krål -- kraal, Nygård -- Nygaard.

Når aa udtales som to vokaler (dvs. når de to a'er hører til hver sin
stavelse som i fx ekstraarbejder), alfabetiseres forbindelsen som to
a'er.

#### (3) Fremmede bogstaver og accenter

Bogstavet ü alfabetiseres som y, ä som æ, ö som ø, ð som d, þ som th;
fransk œ (sammenskrevet o og e) alfabetiseres som o + e. Hvis den eneste
forskel på to ord er at det ene skrives med fremmede bogstaver (fx ü, ä,
ö) og det andet med almindelige bogstaver (fx y, æ, ø), kommer formen
med almindeligt bogstav først, fx Schytt -- Schütt.

Der ses ved alfabetiseringen bort fra accenter, således at fx é, è og ë
alfabetiseres som e, og ç og som c. Hvis den eneste forskel på to ord er
at det ene skrives med accent og det andet uden, kommer formen uden
accent først, fx morter -- mortér, Ree -- Rée.

#### (4) Ordforbindelser

Ved alfabetisering af forbindelser der består af mere end ét ord, fx a
cappella og ad libitum, er der to forskellige principper:

##### (a) Ordning som ét ord

Efter det ene princip alfabetiserer man kun ud fra bogstaverne, dvs. at
man ser bort fra ordmellemrum og alfabetiserer ordforbindelser som om de
var skrevet i ét ord. Følgende ord og ordforbindelser er alfabetiseret
efter dette princip:

> abe

> a cappella

> adgang

> ad hoc-udvalg

> adjø

> ad libitum

> admiral

> ad notam.

##### (b) »Ingenting før noget«

Efter det andet princip følger man en regel om at »ingenting kommer før
noget«, og regner ordmellemrum for et særligt tegn (blanktegn) der
kommer før a i alfabetet. De samme ord og ordforbindelser som ovenfor er
i det følgende alfabetiseret efter dette princip:

> a cappella

> abe

> ad hoc-udvalg

> ad libitum

> ad notam

> adgang

> adjø

> admiral.

Dette princip anføres som hovedregel i den nedennævnte publikation fra
Dansk Standard.

#### (5) Dansk standard

Mere detaljerede regler for alfabetisering af fx forkortelser,
personnavne og firmanavne kan findes i Dansk Standards
Alfabetiseringsregler (DS 377:1980).

### § 5. Accenttegn (accent aigu)

Man kan bruge accenttegn (´ = accent aigu) for at forebygge
misforståelser eller fejllæsninger. Accenttegn kan bruges over både små
og store bogstaver. Med accenten viser man at en stavelse udtales med
stærkt tryk (jf. dog § 5.5 nedenfor). Accenttegnet er således et
hjælpemiddel som man kan bruge for at lette læsningen. Man er imidlertid
aldrig tvunget til at bruge accent: Der er intet ord i
Retskrivningsordbogen som altid skal skrives med accent.

#### (1) *Én*, *ét*, *dér*, *hér*

Man kan sætte accenttegn i en, et, der og her når de udtales trykstærkt.
En sådan brug af accent er ofte til stor hjælp for læseren:

> Jeg købte kun én stol [(dvs. ikke to
> stole)]{style="font-weight: normal; font-style: normal;"}.

> Den slags er jo værst for én selv.

> Én er for lille, og én er for stor.

> Han var én af de bedste på holdet.

> Det kan komme ud på ét.

> Hvem dér?

> Dér har vi aldrig været før.

> Der var mange deltagere dér fra byen.

> Vi har aldrig været dérovre.

> Hér kommer ingen kunder.

Når en og et indgår som dele af andre ord, sættes der normalt ikke
accent: engangsbeløb, enoghalvtreds, femtien, ente (fx en hundred(e) og
ente-del), tre-i-ener, etbenet, etplanshus, ettal, etårig.

#### (2) Ord på trykstærkt *-e*

Man kan valgfrit sætte accenttegn i flerstavelsesord der ender på
trykstærkt ‑e. Det drejer sig i de allerfleste tilfælde om oprindelig
franske ord som også i fransk skrives med accent aigu. Accenten er især
til hjælp for læseren i de ord der ellers falder sammen med andre ord
eller ordformer:

> allé, armé, dragé, dublé, entré, karré, passé, piqué, puré, rosé.

Men accenten kan også bruges i ord der ikke kan forveksles med andre:

> attaché, chargé d'affaires, gelé, idé, kupé, negligé, odyssé, resumé,
> varieté.

Når sådanne ord indgår som dele af andre ord eller ordformer, kan man
ligeledes bruge accent:

> allés [(fx ]{style="font-weight: normal; font-style: normal;"}den
> gamle allés
> træer[)]{style="font-weight: normal; font-style: normal;"},
> attachétaske, entrédør, entréen, geléklump, idémæssig, lindeallé,
> puréagtig, resuméet, rosévin, stillekupé, varietéerne.

#### (3) Ord på trykstærkt *-er*

Man kan sætte accenttegn i ord der ender på trykstærkt ‑er, og som
ellers falder sammen med andre ord:

> manér, mortér, visér.

Når sådanne ord indgår som dele af andre ord eller ordformer, kan man
ligeledes bruge accent: mortérgranat, manérer.

#### (4) Imperativer på trykstærkt *-er*

Man kan sætte accenttegn i imperativer der ender på trykstærkt ‑er.
Accenten er især til hjælp for læseren i de ord der ellers falder sammen
med andre ord eller ordformer:

> analysér, basér, brodér, farsér, gravér, kopiér, notér, polér.

#### (5) Accenttegn til lettelse af læsningen

Man kan sætte accenttegn i tilfælde hvor ord eller ordformer i den givne
sammenhæng ellers ville kunne forveksles med andre ord eller ordformer,
eller hvor en accent i øvrigt vil kunne lette læsningen:

> Vi fór ned ad trappen.

> Dét må dú klare.

> Vi stód op under hele turen.

> Diskutér filmen med dine kammerater!

> ballét, gravérnål, juvelér, kánon, kanón, planét, præcisére, syrén.

Det anbefales dog at være tilbageholdende med at bruge accent i sådanne
tilfælde, og accenttegn over Å/å bør helt undgås. Ofte kan man i stedet
markere en fremhævelse ved understregning, ved kursivering eller ved at
bruge fed skrift.

Når accenten bruges til at skelne mellem ord der begge har stærkt tryk,
betegner accenten lang vokal:

> en vís person

> Han er mát [(medhjælper på et
> skib)]{style="font-weight: normal; font-style: normal;"}.

> Jeg foretrækker nu mós til gullasch.

Når sådanne ord indgår som dele af andre ord eller ordformer, sættes der
ikke accent:

> bevis, kartoffelmos, koksmat, mosede, præcisering, syrenhæk, visdom,
> vismand.

### § 6. Apostrof

Apostrof (') bruges til i visse tilfælde at markere grænsen mellem et
ords stamme og endelser.

#### (1) Forkortelser uden forkortelsespunktum

Der sættes apostrof foran endelser til forkortelser der skrives uden
forkortelsespunktum:

> PC'en *el.* pc'en

> TV'et *el.* tv'et

> HK'erne *el.* hk'erne

> SF'er

> en PH'sk satire

> 2 cm's mellemrum

> pH'en

> USA's præsident

> EU's medlemslande

> SMS'erne *el.* sms'erne

> 3D's historie *el.* 3d's historie.

Ved forkortelser der kan udtales som egentlige ord, er det dog valgfrit
om man vil tilføje endelsen direkte eller bruge apostrof:

> aidsen *el.* aids'en

> epos *el.* epo's indvirkning på kroppen

> Natos *el.* Nato's *el.* NATOs *el.* NATO's.

Foran tungere suffikser bruges ikke apostrof, men bindestreg, fx
SF-agtig, IT-mæssig *el.* it-mæssig (jf. § 57.3.b).

Der sættes ikke apostrof foran endelser til forkortelser der skrives med
forkortelsespunktum:

> 10-pkt.s-program, cand.mag.en, Kbh.s, kbh.ere, ph.d.erne,
> stud.polyt.er.

#### (2) Taltegn, symboler, citatord mv.

Der sættes apostrof foran endelser til taltegn og symboler:

> Han var meget kendt i 1930'erne.

> 165's nattegn

> en 13'er *(el. *trettener*)*

> linje 5's endestation

> 60'er-rock *(el. *tresserrock*)*

> Christian IV's breve

> 20 %'s rabat *(el. *20 pct.s rabat *el.* 20 procents rabat[).
> (Om]{style="font-weight: normal; font-style: normal;"} procent
> [uden]{style="font-weight: normal; font-style: normal;"} s, [se §
> 18.2]{style="font-weight: normal; font-style: normal;"}*)*.

Der sættes dog ikke apostrof efter ordenstal (arabertal) fulgt af
punktum: Christian 4.s breve.

Der sættes apostrof ved citatord mv.:

> De flade a'er er på retur.

> Du bruger for mange og'er.

> Der er en del men'er ved sagen.

> Du skriver dine Jensen'er for utydeligt.

> De skriver om ordet faktisk's udbredelse.

> Der er blevet skrevet en del om bogstavet x's oprindelse.

#### (3) Fremmedord på *-ee*

Der sættes apostrof foran visse endelser til fremmedord der ender på ‑ee
udtalt som i, fx frisbee'en, trainee'er. (Men: en frisbees
flyveegenskaber, firmaets trainees).

#### (4) Proprier

Der sættes som hovedregel ikke apostrof foran endelser (bøjningsendelser
eller suffikser) til proprier:

> Alle de små Jensener var med.

> De to Tysklande blev genforenet i 1990.

> I Danmark er der tre Nykøbinger.

> Volvoen

> grundtvigianer

> Dette er et typisk Villy Sørensensk udtryk.

> bornholmsk

> darwinist

> vordingborgenser.

Der kan dog for tydelighedens skyld sættes apostrof foran endelser som
resulterer i usædvanlige bogstavforbindelser, eller som kan give
anledning til fejllæsninger:

> Rasmus Rask'sk

> Hvor mange Ree'er er der på holdet?

> to Albert'er [(dvs. to personer ved navn
> Albert)]{style="font-weight: normal; font-style: normal;"}

> to Alberte'r [(dvs. to personer ved navn
> Alberte)]{style="font-weight: normal; font-style: normal;"}

> iPad'en *(el. *iPadden*)*.

Se også § 6.3 om fremmedord på -ee.

#### (5) Genitivendelse

Apostrof alene bruges til at betegne genitiv af ord der ender på s, z
eller x, se § 21.2.

#### (6) Udeladte bogstaver (og tal)

Apostrof bruges til at vise at man har udeladt et eller flere bogstaver
for at gengive en udtale:

> hva', ik' *el.* ikk', ku', la' vær', rock'n'roll, se'fø'li', syn's.

Der bruges ikke apostrof ved udeladelse af århundredbetegnelsen i
årstal, fx

> vinteren 24

> 13.2.24

#### (7) Orddeling

Ved orddeling ved linjeskift i forbindelse med apostrof deles der efter
apostroffen, fx

> 1930'-\
> erne

> se'fø'-\
> li'.

§ 7-10. Dobbeltskrivning eller enkeltskrivning {#dobbeltskrivning-eller-enkeltskrivning xmlns="http://www.w3.org/1999/xhtml" h="http://www.w3.org/1999/xhtml"}
==============================================

### § 7. Vokaler

Som hovedregel skrives der enkelt vokal i alle ord uanset om vokalen
udtales lang eller kort, fx aflæsning, lav, men, myg, os, rus, råd, vis,
øg.

Der kan dog forekomme dobbelt vokalbogstav i ord fra fremmede sprog, fx
afrikaans, boom, look, shiitakesvampe, weekend.

§ 8-10. Konsonanter
-------------------

### § 8. Hovedregler

#### (1) Konsonanter mellem vokaler

For konsonanter mellem to vokaler er det hovedreglen at der skrives
dobbelt konsonant efter en kort vokal, fx bassen, hallen, læsse, og
enkelt konsonant efter en lang vokal, fx basen, halen, læse. Denne regel
gælder når vokalen foran konsonanten er trykstærk, samt i
sammensætninger og i visse afledninger.

I sammensatte ord skrives der dobbelt eller enkelt konsonant på samme
måde som i usammensatte ord, fx bassen -- elbassen; basen -- flybasen;
hotellet -- luksushotellet; nemme -- lærenemme. Det gælder også en del
sammensatte ord hvis sidsteled ikke mere forekommer som selvstændige
ord, fx hvalrossen, jordsmonnet, pighvarren, samkvemmet, sådanne.

I afledninger der ender på ‑dom (substantiver) og ‑som (adjektiver),
fordobles m altid foran en bøjningsendelse der begynder med vokal, fx
barndommen, hjælpsomme, lønsommere, sygdommen. -- Om dobbelt- og
enkeltskrivning foran suffikser, se § 9.2.c.

Om dobbelt- og enkeltskrivning af konsonanter mellem vokaler, se i
øvrigt § 9 og § 10.

#### (2) Konsonanter sidst i et ord eller foran andre konsonanter

For konsonanter sidst i et ord eller foran andre konsonanter er det
hovedreglen at der skrives enkelt konsonant uanset om den foranstående
vokal er lang eller kort, fx døtre, klapre, lap, las, vrimle. Denne
regel gælder uanset om vokalen foran konsonanten er trykstærk eller ej.

Om dobbelt- og enkeltskrivning af konsonanter sidst i ord eller foran
andre konsonanter i visse fremmedord, se i øvrigt § 9.2.d.

#### (3) Konsonanter i fremmedord

Fremmedord falder som helhed udenfor reglerne for dobbelt- og
enkeltskrivning af konsonanter. Det skyldes at stavemåden af fremmedord
normalt hænger sammen med stavemåden i det sprog ordet stammer fra. Der
kan derfor ikke gives faste regler for dobbelt- og enkeltskrivning i
opslagsord der er fremmedord, og man må i tvivlstilfælde søge
oplysninger under de enkelte ord i selve ordbogen. -- Se i øvrigt § 9.2.

Om bøjningsformer af fremmedord, se § 10 (specielt § 10.1.b og § 10.2).

### § 9. Konsonanter i opslagsformer

#### (1) Konsonanter mellem vokaler

Der skrives dobbelt konsonant mellem to vokaler når den foranstående
vokal er kort og trykstærk, og den efterfølgende vokal er tryksvag:

> bygge, hedde, masse, skrubbe, skulle, tapper, trække, værre.

Der skrives enkelt konsonant når den foranstående vokal er lang:

> byge, hede, mase, strube, skule, kaper, præke, være.

I enkelte af de ord der kan udtales med både lang og kort vokal, kan der
valgfrit skrives enkelt eller dobbelt konsonant, fx luder *el.* ludder,
skifer *el.* skiffer.

Der er en del undtagelser fra reglen. De vigtigste er følgende:

##### (a) Konsonanterne *j* og *v*

Konsonanterne j og v skrives altid enkelt, fx bajer, støje, doven,
javert.

##### (b) Konsonanterne *d* og *r*

Konsonanterne d og r skrives enkelt i mange ord selvom den foranstående
vokal er (eller kan være) kort, fx nudel, skovrider, jeres, værelse. Der
kan ikke gives faste regler for hvornår d og r skrives enkelt i sådanne
ord. Det tilrådes derfor at man i tvivlstilfælde søger oplysninger under
de enkelte ord i selve ordbogen.

##### (c) Konsonanten *r*

Konsonanten r skrives dobbelt i mange ord selvom den foranstående vokal
er (eller kan være) lang, fx narre, parre, porre. Også her tilrådes det
at man i tvivlstilfælde søger oplysninger i selve ordbogen.

##### (d) *Bredde* og *otte* mv.

Nogle få ord med andre konsonanter end r skrives med dobbelt konsonant
selvom den foranstående vokal er (eller kan være) lang. Det drejer sig
om følgende fem ord: bredde, vidde, skægget (adjektiv), otte, sjette og
om suffikset ‑mæssig (fx forholdsmæssig). Derudover kan der valgfrit
skrives enkelt eller dobbelt konsonant i adjektivet næbet *el.* næbbet
og verbet næbes *el.* næbbes; om fordobling af konsonant efter æ i
bøjningsformer, se § 10.1.d.

#### (2) Konsonanter i fremmedord

Da stavemåden af fremmedord normalt hænger sammen med ordets oprindelse,
kan der ikke gives faste regler for dobbelt- og enkeltskrivning i
sådanne ord, og det tilrådes derfor at man i tvivlstilfælde søger
oplysninger om de enkelte ord i Retskrivningsordbogens alfabetiske del.
Man kan dog bemærke følgende:

##### (a) Efter trykstærk vokal

Mange fremmedord skrives med enkelt konsonant selvom den foranstående
vokal er kort og trykstærk. For eksempel skrives suffikset ‑itisk altid
med enkelt t, fx jesuitisk, politisk, semitisk. Der er ligeledes mange
ord hvor k, p eller t mellem den trykstærke og den tryksvage vokal
skrives enkelt, fx cykel, spektakel, etape, discipel, kapitel, kritisk.

##### (b) Foran trykstærk vokal

I nogle fremmedord skrives der enkelt konsonant umiddelbart foran en
trykstærk vokal, fx defekt, balance, komet, diskutere, i andre skrives
der dobbelt konsonant, fx effekt, ballade. De fleste ord af denne type
har enkeltkonsonant.

##### (c) Foran suffiks

Konsonanter foran suffiks skrives som hovedregel enkelt, fx
ekspressionistisk, filosofere, impressionisme, originalitet,
parallelogram, socialist, tekniker (til forskel fra teknikker, der er
pluralis af teknik).

I nogle ord af fremmed oprindelse skrives der dog dobbelt konsonant
foran suffiks, fx bagatellisere, programmør, tyranni. Især foran
suffikserne ‑ere og ‑ist skrives der ofte dobbelt konsonant, fx
detaillist, kontrollere, protokollere, ræsonnere, klarinettist,
komplettere, rekruttere.

##### (d) Sidst i ord eller foran andre konsonanter

I visse fremmedord skrives der dobbelt konsonant sidst i et ord eller
foran en anden konsonant, fx gløgg, grill, jazz, løss, stress, watt;
aggressiv, attraktion, bulldozer, sufflør, supplere.

### § 10. Konsonanter i bøjningsformer

#### (1) Konsonanter efter trykstærk vokal

Foran en bøjningsendelse der begynder med en vokal, skrives der dobbelt
konsonant når den foranstående vokal er kort og trykstærk, fx matte,
skuddet, tilskuddet. Tilsvarende skrives der enkelt konsonant når den
foranstående vokal er lang, fx hele, skuden. Reglen gælder også for
bøjningsformer af fremmedord, fx giraffen, hittet, parallelle, pubben;
biografen, cottoncoaten, heatet, keruben, parate.

I enkelte af de ord der kan udtales med både lang og kort vokal, kan der
valgfrit skrives enkelt eller dobbelt konsonant, fx granet *el.* grannet
(støvgran; lille mængde), trinene *el.* trinnene, tyranen *el.*
tyrannen.

Der er en del undtagelser fra reglen. De vigtigste er følgende:

##### (a) Ord der ender på *j* eller *v*

Bogstaverne j og v skrives altid enkelt, fx støjen, vejen, navet,
skoven.

##### (b) Ord der ender på *n*, udtalt som *ng*

Et n der udtales som *ng*, skrives altid enkelt, fx bassinet, faconen,
terrænet.

##### (c) Ord der ender på stum konsonant eller *c*

En stum konsonant og konsonanten c skrives altid enkelt, fx aspicen,
atelieret, buffeten, fileter, kompromiset, ragouten, succesen,
trikoterne.

##### (d) Ord med langt *æ*

I nogle få ord skrives der dobbelt konsonant efter et langt æ. Det
drejer sig om ord som en læg, et læg, skæg (substantiv og adjektiv),
væg, en æg, et æg, æt. Der skrives altså fx læggen (til forskel fra
lægen), skægget, skæggeste, væggen (til forskel fra vægen), æggene,
ætten. Derudover kan der valgfrit skrives enkelt eller dobbelt konsonant
i bøjningsformer af ordet næb: næbet *el.* næbbet, næbene *el.* næbbene.

#### (2) Konsonanter efter stavelse med bitryk

For bøjning af usammensatte substantiver der ender på enkelt konsonant,
og hvis sidste stavelse har bitryk -- dvs. ord af typen leksikon,
minimum, møtrik -- gælder følgende regler:

##### (a) Konsonanterne *k*, *m*, *p*, *s*, *t* og hårdt *g*

Konsonanterne k, m, p, s og t samt g når det udtales hårdt, skrives
dobbelt:

> atlasset, bryllupper, facittet, globusser, hotdoggen, humbuggen *el.*
> humbugget, idrætten, kautsjukken, minimummet, møtrikker, punktummer,
> senneppen.

Der kan dog valgfrit skrives enkelt eller dobbelt konsonant i
bøjningsformer af ordet tandem: tandemen *el.* tandemmen, tandemer *el.*
tandemmer.

I substantiver der ender på ‑es, skrives der altid enkelt konsonant, fx
aspargesen, birkesene. Om ord med suffikset ‑dom, se § 8.1.

##### (b) Andre konsonanter

Alle andre konsonanter skrives enkelt:

> dumrianer, leksikoner, marmoret, stencilen.

Der kan dog valgfrit skrives dobbelt-l i bøjningsformerne af festival,
karneval og marskal, fx festivaler *el.* festivaller, karnevaler *el.*
karnevaller og marskaler *el.* marskaller.

§ 11-14. Store og små bogstaver {#store-og-små-bogstaver xmlns="http://www.w3.org/1999/xhtml" h="http://www.w3.org/1999/xhtml"}
===============================

### § 11. Store og små bogstaver i tekstbegyndelse og efter tegn

#### (1) Tekstbegyndelse mv.

Første ord i en tekst, fx i en bog, en avis, et digt, et brev eller en
annonce, skrives med stort begyndelsesbogstav. Det gælder også første
ord i et tekstafsnit, fx i et kapitel, en paragraf eller et »nyt afsnit«
(typografisk afsnit, alinea). Og det gælder ligeledes første ord efter
et punktum; efter et forkortelsespunktum der ikke samtidig fungerer som
slutpunktum i en sætning, skrives dog med lille begyndelsesbogstav.
Efter udeladelses- eller tøveprikker (jf. § 43) der ikke samtidig
fungerer som sluttegn, skrives der ligeledes med lille
begyndelsesbogstav.

Reglerne i denne paragraf gælder også navne af typen von Trier, la Cour
og de Gaulle, forkortelser som cand.mag., it og pc og ordet ad
(vedrørende). Efter fx punktum skrives altså Von Trier, La Cour, De
Gaulle, Cand.mag., It, Pc, Ad pkt. 7. Forkortelser som fx dB og pH der
begynder med lille bogstav og indeholder et stort bogstav, skrives
uændret med lille begyndelsesbogstav i tekstbegyndelse og efter punktum
mv.

#### (2) Efter udråbstegn og spørgsmålstegn

Første ord efter et udråbstegn eller et spørgsmålstegn skrives som
hovedregel med stort begyndelsesbogstav:

> Hun klarede turen uden at vælte! Det havde jeg virkelig ikke regnet
> med.

> Han spurgte om vej til Tivoli! Han kender vist ikke København særlig
> godt.

> Klarede hun turen uden at vælte? Det havde jeg virkelig ikke regnet
> med.

> Kan du sige mig vejen til Tivoli? Jeg kender ikke København særlig
> godt.

Der skrives dog lille begyndelsesbogstav efter et udråbstegn eller et
spørgsmålstegn i direkte anført tale hvor det anførende udtryk (inkvit)
står efter udråbstegnet eller spørgsmålstegnet:

> »Pokkers også!« sagde han, »at det sner igen.«

> »Pokkers også at det sner igen!« sagde han.

> -- Pokkers også at det sner igen! sagde han.

> »Er der nogen hjemme?« råbte hun.

> -- Tror De? spurgte Tine angst og vendte sig fra lysene.

#### (3) Efter kolon

Første ord efter et kolon skrives med stort eller lille
begyndelsesbogstav afhængigt af hvad der følger efter kolonet.

##### (a) Helsætninger

Første ord i helsætninger efter kolon skrives med stort
begyndelsesbogstav (som ved tekstbegyndelse mv., jf. § 11.1):

> Han spurgte om vej til Tivoli: Han kender vist ikke København særlig
> godt.

> Sagen forholder sig således: Huset er for stort, så vi har ikke råd
> til at bo i det.

> Sagen forholder sig således: Huset er for stort. Vi har ikke råd til
> at bo i det.

##### (b) Ledsætninger og sætningsdele

Første ord i ledsætninger og sætningsdele efter kolon skrives som
hovedregel med lille begyndelsesbogstav:

> Han sagde nøjagtig det jeg havde forventet: at han aldrig havde set
> hende før.

> De brugte deres sædvanlige taktik: at trække angriberne offside.

> Der nedbrændte et par mindre bygninger: laboratoriet og kontoret.

> Det var det eneste pressionsmiddel de troede på: direkte henvendelse
> til regeringen.

> Gardinerne fås i fire mønstre: stribede, prikkede, blomstrede og
> pepitaternede.

> Han havde hele familien med: konen, ungerne, svigermekanikken og en
> hoben fætre og kusiner.

Dog kan det der følger efter kolon i titler og overskrifter, skrives med
stort begyndelsesbogstav, selvom der ikke er tale om helsætninger:

> Modul 1: Indledning *el.* indledning

> Mikrobiologi: En *el.* en indføring

> Postmodernisme: Viden *el.* viden og magt

> Skakverdensmester før tid: Om *el.* om Magnus Carlsens opstigning til
> verdenstoppen

> Vælgerne er enige: Nej *el.* nej til præsidenten

> Musiker: Aldrig *el.* aldrig på scenen uden amulet

#### (4) Punktopstillinger mv.

Ved punktopstillinger i regnskaber, forretningsbreve, spørgeskemaer mv.
kan første ord i nyt punkt (ny linje) skrives med stort eller med lille
begyndelsesbogstav:

  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- ------- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  *Budgettet ser således ud:*                                                                                                                                                                                                       *el.*   *Budgettet ser således ud:*
  *Husleje \...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...*                *husleje \...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...*
  *Varme \...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...*                  *varme \...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...*
  *Forsikringer \...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...*           *forsikringer \...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...\...*
                                                                                                                                                                                                                                            
                                                                                                                                                                                                                                            
  --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- ------- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

  ---------------------------- ------- ----------------------------
  *Navn:*                      *el.*   *navn:*
  *Adresse:*                           *adresse:*
  *Personnummer:*                      *personnummer:*
  *Fødested:*                          *fødested:*
  *Antal hjemmeboende børn:*           *antal hjemmeboende børn:*
  ---------------------------- ------- ----------------------------

  --------------------- ------- ---------------------
  *Med venlig hilsen*   *el.*   *Med venlig hilsen*
  *Dansk Sprognævn*             *Dansk Sprognævn*
  *Arnold Skjern*               *Arnold Skjern*
  *Seniorforsker*               *seniorforsker*
  --------------------- ------- ---------------------

Bemærk at sluthilsner som fx Med venlig hilsen skrives med stort
begyndelsesbogstav når de indleder en linje efter ét eller flere
linjeskift. Det samme gælder slutformler som fx På udvalgets vegne og
E.b. (= Efter bemyndigelse).

#### (5) NB!

Reglerne i § 11.1-11.4 ovenfor om brug af lille begyndelsesbogstav i
visse tilfælde gælder ikke de ord der efter reglerne i § 12 om stort
begyndelsesbogstav i proprier skal skrives med stort begyndelsesbogstav.
De gælder heller ikke når der bruges store bogstaver i forkortelser (jf.
§ 14).

### § 12. Store og små bogstaver i proprier

#### (1) Hovedregel

Proprier skrives med stort begyndelsesbogstav.

Denne regel gælder uanset om de pågældende proprier mere eller mindre
tydeligt består af ord der også kan bruges som appellativer. I nogle
tilfælde er det særlig vanskeligt at afgøre om et ord er brugt som
proprium eller ej. Sådanne tilfælde er behandlet nærmere i § 12.13.

I øvrigt kan et proprium altid skrives på samme måde som bæreren,
ejeren, forfatteren, komponisten e.l. skriver det (jf. § 61). Dette
gælder også brugen af store og små bogstaver.

#### (2) Flerleddede navne

I proprier der består af mere end ét ord, skrives der som hovedregel
stort begyndelsesbogstav i det første ord og i de mere betydningsfulde
ord (dvs. andre ord end konjunktioner, præpositioner, artikler og
enkelte andre småord), fx Østre Landsret, Gorm den Gamle, Under Elmene,
Det Danske Sprog- og Litteraturselskab.

Som det fremgår, skrives en artikel der står som første ord i et
flerleddet navn, med stort begyndelsesbogstav, fx Det Kongelige Teater,
De Kanariske Øer. Dette gælder imidlertid ikke når artiklen står adskilt
fra resten af navnet. I sådanne tilfælde skrives artiklen altid med
lille begyndelsesbogstav, fx det nyistandsatte Kongelige Teater, de
solbeskinnede Kanariske Øer.

Om brugen af store og små bogstaver i flerleddede bogtitler mv., se §
12.9.

#### (3) Personer

Navne på personer, herunder fornavne, mellemnavne, efternavne, øgenavne,
kælenavne og tilnavne, skrives med stort begyndelsesbogstav:

> Else, Else Hansen, Anne Friis Jensen, Peter Overgård, Hansen,
> Fyrtårnet, Fy, Bivognen, Bi, Gøg, Gokke, Joakim von And, Putte, Børge
> Braktud, Kirsten Giftekniv, Thorkil Livrem, PH, Storm P.,
> Håndværkerjohn *el.* Håndværker-John, Store Robert, Valdemar Sejr,
> Alexander den Store, Gorm den Gamle, Frederik den Tiende.

Navne på religiøse og mytologiske skikkelser skrives ligeledes med stort
begyndelsesbogstav:

> Gud, Vorherre *(el. *Vor Herre*)*, Herren, Faderen, Frelseren,
> Kristus, Skaberen, Sønnen, Menneskesønnen, Helligånden, Jomfru Maria,
> Den Hellige Jomfru, Madonna, Moder Jord, Sankt Peter, Allah, Buddha,
> Djævelen, Satan, Fanden, Apollon, Venus, Freja, Odin, Fenrisulven,
> Midgårdsormen.

I udråb, eder o.l. skrives der dog med lille begyndelsesbogstav:

> gud ske lov *(el. *gudskelov*)*

> gud bevares *(el. *gudbevares*)*

> vorherre bevares

> et herrens vejr

> satans også

> av for fanden

> fanden tage mig.

Navne i pluralis skrives med stort begyndelsesbogstav:

> Kennedyerne, Valdemarerne, Helveg Petersenerne, Susanner [(fx
> ]{style="font-weight: normal; font-style: normal;"} Der er tre
> Susanner i
> klassen[)]{style="font-weight: normal; font-style: normal;"} .

Om tiltaleord og titulaturer mv., se § 13.

#### (4) Dyr, planter mv.

Navne der er givet til dyr og ting, fx redskaber og transportmidler,
skrives med stort begyndelsesbogstav:

> [(hunden)]{style="font-weight: normal; font-style: normal;"} Vaks,
> [(hesten)]{style="font-weight: normal; font-style: normal;"} Blis,
> [(tyren)]{style="font-weight: normal; font-style: normal;"} Ferdinand,
> [(sværdet)]{style="font-weight: normal; font-style: normal;"} Skræp,
> [(isbryderen)]{style="font-weight: normal; font-style: normal;"}
> Isbjørn, [(flaget)]{style="font-weight: normal; font-style: normal;"}
> Dannebrog.

Systematiske latinske navne på dyr og planter skrives ligeledes med
stort begyndelsesbogstav:

> Mammalia, Canis, Ursidae, Betula, Viola.

I toleddede artsnavne skrives dog kun første ord (slægtsbetegnelsen) med
stort begyndelsesbogstav, mens andet ord (artsbetegnelsen) skrives med
lille begyndelsesbogstav:

> Canis lupus, Ursus maritimus, Viola cornuta.

Almindelige benævnelser på dyr, planter, madvarer mv. skrives med lille
begyndelsesbogstav:

> pattedyr, hund, bjørn, ulv, isbjørn, zebra, gråspurv, schæfer, nældens
> takvinge, bredøret flagermus, birk, viol, coxorange, cabernet
> sauvignon, chianti, cheddar, gorgonzola.

I nogle tilfælde bruges samme oprindelig latinske ord som systematisk
navn og almindelig dansk benævnelse. De to anvendelser af ordet
adskiller sig da kun fra hinanden ved forskellen med hensyn til
begyndelsesbogstav:

> Alligator -- alligator

> Bellis -- bellis.

#### (5) Geografiske områder

Navne på geografiske områder, have, stater, landskaber, skove, søer,
vandløb, bjerge, bestemte træer og sten mv., byer, kvarterer, gader,
pladser og andre lokaliteter skrives med stort begyndelsesbogstav (om
brug af store og små bogstaver i småord, se § 12.2):

> Europa, Mellemamerika, Nordpolen *(men: *den magnetiske nordpol*)*,
> Norden, Vesten, Orienten, Det Fjerne Østen, Vestjylland, Region
> Syddanmark, Hyltebjerg Sogn, Københavns Kommune, Københavns og
> Frederiksberg Kommune(r) *(= *Københavns Kommune og Frederiksberg
> Kommune*)*, Den Engelske Kanal, Det Kaspiske Hav, Lillebælt,
> Forbundsrepublikken Tyskland, USA, Salomonøerne, Provence, Dyrehaven,
> Kongehøjene, Lille Vildmose, Frejlev Skov, Østre Anlæg, Genesaret Sø,
> Peblingesøen, Rhinen, Suså, Andesbjergene, Klopstocks Eg, Kongeegen,
> Jons Kapel, Rokkestenen, København, Vordingborg By *(eller, svarende
> til *byen Vordingborg[:
> ]{style="font-weight: normal; font-style: normal;"}Vordingborg by*)*,
> Port Said, Nørrebro, Hanens Kvarter, Vollsmose, La Cours Vej, Peter
> Bangs Vej, Jomfru Ane Gade, Kattesundet, Under Elmene, Højbro Plads,
> Valby Bakke.

Med lille begyndelsesbogstav skrives fx

> ækvator, den sydlige polarkreds, den nordlige polarkreds.

Navne på religiøse og mytologiske steder skrives med stort
begyndelsesbogstav:

> Bifrost, Helvede, Himmerig *el.* Himmerige, Paradis, Paradisets Have,
> Valhal.

Udråb, eder o.l. skrives dog med lille begyndelsesbogstav, fx

> et helvedes besvær

> av for helvede.

Navne i pluralis skrives med stort begyndelsesbogstav, fx

> de to Tysklande

> de to Koreaer.

#### (6) Himmellegemer mv.

Navne på planeter, stjerner, stjernebilleder og andre himmellegemer mv.
skrives med stort begyndelsesbogstav:

> Aftenstjernen, Andromedatågen, Berenikes Hovedhår, Jupiter,
> Karlsvognen, Krebsen, Mars, Morgenstjernen, Polarstjernen, Store
> Bjørn, Tvillingerne, Vandmanden.

Der skrives valgfrit:

> Jorden *el.* jorden

> Mælkevejen *el.* mælkevejen

> Månen *el.* månen

> Solen *el.* solen.

Med lille begyndelsesbogstav skrives:

> atmosfæren

> ekliptika

> stratosfæren

> vendekreds [(i]{style="font-weight: normal; font-style: normal;"}
> Krebsens vendekreds[ og
> ]{style="font-weight: normal; font-style: normal;"}Stenbukkens
> vendekreds[)]{style="font-weight: normal; font-style: normal;"}.

Der skrives ligeledes med lille begyndelsesbogstav i forbindelser som
Jeg er vandmand (dvs. født i Vandmandens tegn).

#### (7) Institutioner, firmaer mv.

Navne på offentlige og private institutioner, foreninger,
sammenslutninger, organisationer, virksomheder, firmaer, politiske
partier mv. skrives med stort begyndelsesbogstav (om brug af store og
små bogstaver i småord, se § 12.2):

> Folketinget, Statsministeriet, Børne- og Undervisningsministeriet,
> Nordisk Ministerråd, Center for Videregående Uddannelser,
> Beredsskabsstyrelsen, Folketingets Finansudvalg, Finansudvalget, Det
> Kongelige Teater, Københavns Universitet, Institut for Kultur og
> Identitet, Forenede Nationer, Nato *(el. *NATO*)*, Den Europæiske
> Union, EU, Kommissionen for de *(el. *De*)* Europæiske Fællesskaber,
> Carlsbergfondet, Dansk-Russisk Forening, Verdensbanken, Kommunernes
> Landsforening, Gentofte Kommunalbestyrelse, Gentofte Kommune, Region
> Syddanmark, Københavns Kommune, Københavns og Frederiksberg Kommune(r)
> *(= *Københavns Kommune og Frederiksberg Kommune*)*, Midt- og
> Vestsjællands Politi, Teknisk Forvaltning, Økonomiudvalget,
> Arbejderbevægelsens Erhvervsråd, J.C. Hansen og Sønner, Malerfirmaet
> Nielsen og Co., Brændstrup Maskinfabrik, Danske Sømands- og
> Udlandskirker, Foreningen for Madkundskab, Fonden Ensomme Gamles Værn,
> Børns Vilkår, Danske Studerendes Fællesråd, Det Radikale Venstre,
> Foreningen af Levnedsmiddelingeniører og -kandidater.

Foruden de officielle navne på institutioner, foreninger mv. skrives
også uofficielle kaldenavne med stort begyndelsesbogstav:

> Sprognævnet *(*Dansk Sprognævn*)*, Nationalbanken *(*Danmarks
> Nationalbank*)*, Ministerrådet *(*Rådet for den Europæiske Union*)*,
> De Konservative *(*Det Konservative Folkeparti*)*.

Navne på institutioner eller embeder som Folketingets Ombudsmand og
Ombudsmanden skrives med stort begyndelsesbogstav. De tilsvarende
betegnelser på de personer der udøver funktionen, skrives normalt med
lille begyndelsesbogstav, dvs. Folketingets ombudsmand, ombudsmanden
(jf. dog § 12.13.b).

Om brugen af stort eller lille begyndelsesbogstav i betegnelser som
ministeriet, kommunen, firmaet, nævnet, se § 12.13.b.

Med lille begyndelsesbogstav skrives betegnelser som staten, regeringen,
kirken, folkekirken, folkeskolen, skattevæsnet *el.* skattevæsenet og
sygehusvæsnet *el.* sygehusvæsenet. Også betegnelser som forsvaret,
flyvevåbnet *el.* flyvevåbenet, søværnet og hjemmeværnet skrives med
lille begyndelsesbogstav når de fungerer som almene overbegreber. Når
der er tale om navne på selve organisationerne, skrives de dog med stort
begyndelsesbogstav: Forsvaret, Flyvevåbnet, Søværnet og Hjemmeværnet.

#### (8) Bygninger mv.

Navne på bygninger, dele af bygninger, monumenter, mindesmærker o.l.
skrives med stort begyndelsesbogstav (om brug af store og små bogstaver
i småord, se § 12.2):

> Christiansborg, Christiansborg Slot, Børsen, Assens Rådhus, Statens
> Museum for Kunst, Roskilde Domkirke, Tilst Kirke, Kulturhuset
> Pilegården, Prinsens Palæ, Blåtårn, Grædemuren, Triumfbuen, Den
> Ukendte Soldats Grav, Landsoldaten, Kong Svends Høj.

Om brugen af stort eller lille begyndelsesbogstav i betegnelser som
rådhuset, museet, domkirken, se § 12.13.b.

#### (9) Bøger, kunstværker, love mv.

Navne på bøger, film, teaterstykker, malerier, skulpturer,
kompositioner, sange o.l. skrives altid med stort begyndelsesbogstav i
det første ord. Det gælder også selvom det første ord er en artikel.
Desuden kan alle mere betydningsfulde ord i sådanne titler mv. skrives
med stort begyndelsesbogstav:

> Biblen *(el. *Bibelen*)*

> Gamle testamente *el.* Gamle Testamente

> Det gamle testamente *el.* Det Gamle Testamente *(men: *det
> nyoversatte Gamle testamente *el.* det nyoversatte Gamle Testamente*)*

> Bombi Bitt og jeg *el.* Bombi Bitt og Jeg

> Det forsømte forår *el.* Det Forsømte Forår

> Italiensk for begyndere *el.* Italiensk for Begyndere

> Tågernes kaj *el.* Tågernes Kaj

> Schweizerløven

> Den lille havfrue *el.* Den Lille Havfrue

> Måneskinssonaten

> Figaros bryllup *el.* Figaros Bryllup

> Den signede dag *el.* Den Signede Dag

> Bag duggede ruder *el.* Bag Duggede Ruder

> Kvinde min *el.* Kvinde Min.

##### (a) Lange titler

I lange titler anbefales det at nøjes med at skrive første ord med stort
begyndelsesbogstav:

> Eventyret om buschaufføren som tænkte at hva' faen og andre eventyr
> for børn over 18 år

> Bibliografi over arbejder om nyere principper for arbejdsledelse

> Muldvarpen der ville vide hvem der havde lavet lort på dens hoved.

##### (b) Love og bekendtgørelser mv.

Navne på love mv. der opfattes som litterære eller kulturelle
dokumenter, skrives efter samme regler som navne på bøger, kunstværker
mv.:

> Jyske lov *el.* Jyske Lov

> Chr. V's danske lov *el.* Chr. V's Danske Lov

> Magna carta *el.* Magna Carta.

Også andre love, bekendtgørelser, cirkulærer o.l. kan skrives efter
reglerne for bogtitler mv. I sådanne tilfælde anbefales det dog at
skrive med lille begyndelsesbogstav: færdselsloven, grundloven, lov om
social service, bekendtgørelse af 22.3.1948 om retskrivningen,
Justitsministeriets vejledning om sproget i love og andre
retsforskrifter.

##### (c) Kurser mv.

Navne på kurser, foredrag o.l. skrives efter samme regler som navne på
bøger mv.:

> Moderne dansk litteratur *el.* Moderne Dansk Litteratur

> Introduktion til mikrobiologi *el.* Introduktion til Mikrobiologi.

Mere generelle benævnelser på fag, emner, discipliner, studier,
uddannelser o.l. skrives normalt med lille begyndelsesbogstav:

> litteraturhistorie, biologi, faget dansk, dansk, nationaløkonomi,
> databasedesign, ergoterapeutuddannelsen.

##### (d) Videnskabelige love, regler mv.

Navne på love og regler i fysik, matematik mv. skrives med lille
begyndelsesbogstav (medmindre der indgår et proprium i dem):

> tyngdeloven, højrehåndsreglen, Ohms lov, Arkimedes' lov, Verners lov.

Om brug af anførselstegn ved navne på bøger mv., se § 58.3.

#### (10) Sammensætninger

##### (a) Proprier

Sammensætninger der indeholder et proprium, og som i sig selv er
proprier, skrives ligesom andre proprier med stort begyndelsesbogstav:

> Andesbjergene, Annapige, Atlantpagten, Egtvedpigen, Eksjugoslavien,
> Europaskolen, Hviderusland, Nazityskland, Nillermand, Nordkorea,
> Norditalien, Panamakanalen, Roskildevej, Salomonøerne,
> Silkeborgsøerne, Sommerdanmark, Storkøbenhavn, Sønderjylland,
> Udkantdanmark *el.* Udkantsdanmark, Vestamager, Vinternorge,
> Århusbugten.

##### (b) Ikkeproprier

De fleste sammensætninger der indeholder et proprium, men som ikke i sig
selv er proprier, kan skrives med stort eller lille begyndelsesbogstav:

> Atlanterhavskyst *el.* atlanterhavskyst

> Asienkorrespondent *(el. *Asienskorrespondent*) el.*
> asienkorrespondent *(el. *asienskorrespondent*)*

> Blicherforsker *el.* blicherforsker

> Beatlesfan *el.* beatlesfan

> Christiansborgjournalist *el.* christiansborgjournalist

> Londontur *el.* londontur

> Mozartbegejstret *el.* mozartbegejstret

> Nobelpristager *el.* nobelpristager

> Nordpolsekspedition *el.* nordpolsekspedition

> Nørrebrolejlighed *el.* nørrebrolejlighed

> Rhinsejlads *el.* rhinsejlads

> Vejleborger *el.* vejleborger.

Om eventuel brug af bindestreg i sådanne sammensætninger, se § 57.8.

I fast indarbejdede sammensætninger med et proprium som førsteled
anbefales det dog at skrive med lille begyndelsesbogstav:

> chilesalpeter, danmarkshistorie, dannebrogsflag, faksekalk,
> folketingsvalg, højesteretsdommer, middelhavssalt, tychobrahesdag.

Fast indarbejdede sammensætninger uden tydelig forbindelse til det
(oprindelige) proprium der indgår i dem, skrives altid med lille
begyndelsesbogstav:

> akillessene, amagermad, ariadnetråd, dieselmotor, isabellafarvet,
> napoleonskage, røntgenfotografere, røntgenstråler, waleskringle.

Når sammensætninger der indeholder et proprium, men som ikke i sig selv
er proprier, står som opslagsord i selve ordbogen, er de som hovedregel
skrevet med lille begyndelsesbogstav.

##### (c) Gruppesammensætninger

Hvis førsteleddet i en sammensætning er et proprium der er skrevet i
mere end ét ord, sættes der en bindestreg mellem propriet og
sammensætningens sidsteled, og i øvrigt skrives propriet på samme måde
som når det står alene:

> Brødrene Nielsen-koncernen, Claus Meyer-opskrift, en Østre
> Landsrets-dom, H.C. Andersen-ekspert, Johannes V. Jensen-påvirket, New
> York-rejse, Storm P.-figur, von Karajan-indspilning.

Hvis sammensætningen i sig selv er et proprium, skrives også
sammensætningens sidsteled med stort begyndelsesbogstav:

> H.C. Andersen-Samfundet, Max Planck-Instituttet, Pro Musica-Koret,
> Storm P.-Museet.

I gadenavne sættes der dog ikke bindestreg mellem navnet og
sammensætningens sidsteled:

> Harald Jensens Plads, Peter Bangs Vej, Sankt Hans Torv.

Om stavning af gadenavne i øvrigt, se *Vejledning i retskrivning af
vejnavne*, Dansk Sprognævns skrifter, 2001.

Om gruppesammensætninger i øvrigt, se § 57.7.

#### (11) Afledninger

Afledninger til proprier skrives som hovedregel med lille
begyndelsesbogstav:

> københavner, nyborgenser, skibonit, skagbo, englænder, hollandsk,
> grundtvigianer, marxisme, marxist, holbergiana, kierkegaardiana,
> balkanisere, pasteurisere.

Man kan dog bruge stort begyndelsesbogstav i mere lejlighedsvise
afledninger eller i afledninger hvor man ønsker at lægge vægt på
forbindelsen til navnet:

> Laudrupagtig, den Bohrske familie, de Kierkegaardske paradokser, den
> Wiedske satire, Højholtiana.

Der skrives altid med stort begyndelsesbogstav ved afledninger til mere
end ét ord (gruppeafledninger): de Niels Bohrske teorier, den Pia Olsen
Dyhrske politik.

#### (12) Navne uden bestemthedsendelse

Navne der normalt bruges med bestemthedsendelse, kan undertiden
forekomme uden. I sådanne tilfælde bruges store og små
begyndelsesbogstaver efter samme regler som når navnene har
bestemthedsendelse:

> den uhyggelige Fenrisulv *(jf. *Fenrisulven*)*

> vor dejlige Jord/jord *(jf. *Jorden/jorden[; jf. §
> 12.6]{style="font-weight: normal; font-style: normal;"}*)*

> den unge Sovjetunion *(jf. *Sovjetunionen*)*

> den skønne Dyrehave *(jf. *Dyrehaven*)*

> det nyvalgte Folketing, et nyvalgt Folketing *(jf. *Folketinget*)*

> det daværende Miljø- og Fødevareministerium *(jf. *Miljø- og
> Fødevareministeriet*)*

> Kære Sprognævn *(jf. *Sprognævnet*)*

> et Ekstra Blad *(jf. *Ekstra Bladet*)*

> de uvejsomme Pyrenæer *(jf. *Pyrenæerne*)*

> Appenninerkæden *(jf. *Appenninerne*)*

> Rhinsejlads/rhinsejlads [(jf. § 12.10.b; jf.
> ]{style="font-weight: normal; font-style: normal;"}Rhinen[)]{style="font-weight: normal; font-style: normal;"}.

#### (13) Særlige problemer

I nogle tilfælde er det særlig vanskeligt at afgøre om et ord er brugt
som et proprium (eller en del af et proprium) eller ej. Om man skal
skrive med stort eller lille begyndelsesbogstav, må derfor undertiden
bero på et personligt skøn:

##### (a) Proprier eller appellativer?

Mange ord og ordforbindelser bruges snart som proprier, snart som
appellativer. Det er grunden til at en del af de eksempler der er
skrevet med stort begyndelsesbogstav her i § 12, kan træffes i andre
forbindelser hvor de -- fuldt korrekt -- er skrevet med lille
begyndelsesbogstav. Det kan ikke altid fastsættes at et bestemt ord i
enhver sammenhæng skal skrives enten med stort eller med lille
begyndelsesbogstav.

For eksempel skrives navnet på den højeste domstol i Danmark med stort
begyndelsesbogstav: Højesteret; men i en sammenhæng som fx »I Sverige
kalder man højesteret for Högsta domstolen« bruges der lille
begyndelsesbogstav. Og man skriver også med stort begyndelsesbogstav
hvis man bruger kaldenavnet (De) Konservative om et parti med det
officielle navn Det Konservative Folkeparti; derimod skriver man med
lille begyndelsesbogstav hvis ordet blot bruges om personer med en
konservativ indstilling: (de) konservative. Tilsvarende er Københavns
Havn den korrekte skrivemåde for den havn der hedder sådan; men det er
lige så korrekt at betegne den som Københavns havn (dvs. den havn der
findes i København, uden tanke på hvad den hedder officielt).

Andre eksempler:

> Motionsklubben Hopla [(en klub ved navn Motionsklubben
> Hopla)]{style="font-weight: normal; font-style: normal;"}

> motionsklubben Hopla [(en motionsklub ved navn
> Hopla)]{style="font-weight: normal; font-style: normal;"}.

> Børnehuset på Holmen [(et børnehus ved navn Børnehuset på
> Holmen)]{style="font-weight: normal; font-style: normal;"}

> børnehuset på Holmen [(et børnehus der ligger på
> Holmen)]{style="font-weight: normal; font-style: normal;"}.

##### (b) Propriumskarakter i snævrere kredse

Et ord kan godt have propriumskarakter for én sprogbruger eller én
gruppe af sprogbrugere uden at have det for andre. Blandt andet kan
betegnelser for lokaliteter, institutioner, personer mv. få karakter af
proprier for personer der er særlig fortrolige med eller har en særlig
tilknytning til de pågældende institutioner mv. Det kan fx gælde
betegnelser som

> fabrikken, ministeriet, banken, kirken [(om en bestemt
> kirke)]{style="font-weight: normal; font-style: normal;"}, museet,
> kommunen, sommerhuset, banegården, gågaden, tinget, byrådet,
> kommunalbestyrelsen, nævnet, direktionen, direktøren,
> udenrigsministeren, ministeren, formanden, chefen, præsten,
> lagerforvalteren, piccoloen, moster, morfar, far, mor.

Det må anbefales at være tilbageholdende med at bruge stort
begyndelsesbogstav i sådanne betegnelser, især når man henvender sig til
personer udenfor de kredse hvor den pågældende betegnelse har fået
propriumskarakter.

##### (c) Historiske begivenheder mv.

Betegnelser på historiske begivenheder og epoker mv. og på geologiske
perioder kan altid skrives med lille begyndelsesbogstav. De kan dog
opfattes som proprier, og der er derfor også mulighed for at skrive dem
med stort begyndelsesbogstav:

> reformationen *el.* Reformationen

> den franske revolution *el.* Den Franske Revolution

> besættelsen *el.* Besættelsen

> anden verdenskrig *el.* Anden Verdenskrig

> grevens fejde *el.* Grevens Fejde

> femte maj *el.* Femte Maj

> stenalderen *el.* Stenalderen

> jura *el.* Jura

> kridttiden *el.* Kridttiden.

Også betegnelser på sportsarrangementer, kulturelle begivenheder o.l. er
der mulighed for at skrive med stort begyndelsesbogstav:

> Ærø jazzfestival *el.* Ærø Jazzfestival

> Sjælland rundt *el.* Sjælland Rundt

> olympiske lege *el.* Olympiske Lege.

Det kan anbefales først og fremmest at følge en nogenlunde fast praksis
indenfor samme tekst. Derudover kan det være hensigtsmæssigt at søge at
begrænse brugen af store begyndelsesbogstaver til betegnelser for mere
skelsættende begivenheder og til betegnelser for nogenlunde
veldefinerede og velafgrænsede begivenheder og epoker.

Månederne og ugedagene og betegnelser på religiøse og nationale højtider
og festdage mv. skrives med lille begyndelsesbogstav:

> januar, mandag, påske, pinse, jul, nytår, juleaften, nytårsaften,
> grundlovsdag, mortensaften, sankthansaften, fastelavn, valentinsdag,
> valborgaften *el.* valborgsaften, ramadan, eid, yom kippur, mors dag.

Der skrives Kristi himmelfartsdag og Mariæ bebudelsesdag.

##### (d) Ordener mv.

Betegnelser på fortjensttegn, ordenstegn, priser, udmærkelser mv. kan
altid skrives med lille begyndelsesbogstav. De kan dog opfattes som
proprier, og der er derfor også mulighed for at skrive dem med stort
begyndelsesbogstav:

> elefantordenen *el.* Elefantordenen

> fortjenstmedaljen *el.* Fortjenstmedaljen

> dronningens ur *el.* Dronningens Ur

> æreslegionen *el.* Æreslegionen

> jernkorset *el.* Jernkorset

> natur- og miljøprisen *el.* Natur- og Miljøprisen

> akademiets store pris *el.* Akademiets Store Pris.

I de tilfælde hvor der indgår et proprium i betegnelsen, er det som
regel mest nærliggende at skrive med stort begyndelsesbogstav (jf. også
§ 12.10 om sammensætninger med proprier):

> Nobelprisen *(el. *nobelprisen*)*

> Dannebrogordenen *(el. *dannebrogordenen*)*

> Victoriakorset *(el. *victoriakorset*)*

> H.C. Andersen-Prisen *(el. *H.C. Andersen-prisen*)*

> en Oscar *(el. *en oscar*)*.

Betegnelser for personer der er indehavere af ordener mv., skrives som
hovedregel med lille begyndelsesbogstav:

> ridder

> elefantridder

> kommandør af Dannebrog

> dannebrogsmand *(el. *Dannebrogsmand[, jf. §
> 12.10.b]{style="font-weight: normal; font-style: normal;"}*)*

> nobelpristager *(el. *Nobelpristager[, jf. §
> 12.10.b]{style="font-weight: normal; font-style: normal;"}*)*

> oscarvinder *(el. *Oscarvinder[, jf. §
> 12.10.b]{style="font-weight: normal; font-style: normal;"}*)*.

Om evt. brug af stort begyndelsesbogstav i titulaturer og titler, se §
13.3.

I nogle tilfælde kan en betegnelse referere til såvel prismodtageren som
selve prisen. I sådanne tilfælde kan der valgfrit skrives med stort
eller lille begyndelsesbogstav, fx årets forfatter *el.* Årets
Forfatter.

### § 13. Store og små bogstaver i tiltaleord og titulaturer

#### (1) Tiltalepronomener

Tiltalepronomenerne I og De skrives med stort begyndelsesbogstav. Det
samme gælder bøjningsformerne af De: Dem og Deres. De øvrige
tiltalepronomener og bøjningsformer af tiltalepronomener skrives med
lille begyndelsesbogstav:

> du, dig, din, dit, dine, jer, jeres, eder, eders.

#### (2) Særlige titulaturer

Særlige titulaturer som de følgende skrives med stort
begyndelsesbogstav, uanset om de bruges i tiltale eller omtale:

> Deres Majestæt

> Hans Majestæt

> Hans Majestæt Kongen

> Hans Majestæt Kong Frederik

> Hendes Majestæt

> Hendes Majestæt Dronningen

> Hendes Majestæt Dronning Margrethe

> Deres Kongelige Højhed

> Hans Kongelige Højhed Prinsen

> Hendes Kongelige Højhed Prinsesse Benedikte

> Hans Højhed

> Hendes Højhed

> Hans Højærværdighed

> Deres Excellence

> Hans Excellence.

#### (3) Andre titulaturer

Øvrige titulaturer, titler, stillingsbetegnelser og grader mv. skrives
som hovedregel med lille begyndelsesbogstav, både i tiltale og omtale:

> kong Frederik

> dronning Margrethe

> grev Moltke

> Ernst greve Moltke

> kongen

> dronningen

> majestæten

> excellencen

> statsministeren

> professoren

> doktoren

> direktøren

> direktør Svane

> pastor Nielsen

> Til personalechefen

> seniorforsker Skjern

> psykolog Tanja Sørensen

> ph.d. Peter Holm

> datamanager Markus Nielsen

> controller Anne Skov

> fru Petersen

> hr. Eriksen

> onkel Harry

> kusine Isabella.

### § 14. Store og små bogstaver i forkortelser o.l.

Denne paragraf giver ikke en udtømmende oversigt over hvordan man bruger
store og små bogstaver i forkortelser o.l. Men den behandler nogle
vigtige grupper af forkortelser mv. hvor brugen af store og små
bogstaver ligger nogenlunde fast.

#### (1) Proprier og dele af proprier

Reglerne i § 12 om stort begyndelsesbogstav i proprier gælder også for
forkortelser der er proprier eller dele af proprier:

> PH [(dvs. Poul
> Henningsen)]{style="font-weight: normal; font-style: normal;"
> word="dvs."}

> Kbh.

> Benelux

> Nato *(el. *NATO*)*

> Storm P.

> Skt. Peter

> St. Heddinge

> Det Kgl. Teater

> Chr. V's da. lov *el.* Chr. V's Da. Lov

> Storkbh.

> Harald Jensens Pl.

#### (2) Initialforkortelser: proprier

De fleste initialforkortelser (dvs. forkortelser dannet af
begyndelsesbogstaver fra flere ord eller orddele) der er proprier,
skrives med store bogstaver:

> USA, FN, DSB, EU, BT, KFUM, OPEC, FAO, KODA, DMI, SF

De forkortelser der normalt læses som almindelige ord (dvs. ikke blot
som en række af bogstaver), kan dog også skrives med stort
begyndelsesbogstav alene:

> Nato *(el. *NATO*)*

> Unesco *(el. *UNESCO*)*

> Efta *(el. *EFTA*)*

> Uefa *(el. *UEFA*)*

Om navne på firmaer, foreninger mv., se i øvrigt § 61.3.

#### (3) Initialforkortelser: appellativer

De fleste initialforkortelser der er appellativer, skrives valgfrit med
store eller små bogstaver:

> A/S *el.* a/s

> AKT-vejleder *el.* akt-vejleder

> BH *el.* bh

> BMX-cykel *el.* bmx-cykel

> BNP *el.* bnp

> CD *el.* cd

> DVD *el.* dvd

> FM *el.* fm

> HA *el.* ha

> HF *el.* hf

> HR-chef *el.* hr-chef

> ID-kort *el.* id-kort

> ISBN *el.* isbn

> IT *el.* it

> LCD-skærm *el.* lcd-skærm

> LSD *el.* lsd

> PDF *el.* pdf

> SMS *el.* sms

> TV *el.* tv

> USB-nøgle *el.* usb-nøgle

> WC *el.* wc

Oprindelige forkortelser der læses som almindelige ord (dvs. ikke blot
som en række af bogstaver), skrives dog i en del tilfælde med små
bogstaver, fx

> aids, epo, hiv, ufo

I ord som a-kraft, e-mail, p-pille og p-skive, hvor forkortelsen ikke
kan stå alene, skrives forkortelsen med lille bogstav.

Der er kun få tilfælde af forkortelser med både punktum og store
bogstaver. Det drejer sig bl.a. om forkortelser for hædersbevisninger
o.l., fx

> DM. [(dvs.
> ]{style="font-weight: normal; font-style: normal;"}dannebrogsmand[)]{style="font-weight: normal; font-style: normal;"}

> H.M. [(dvs. ]{style="font-weight: normal; font-style: normal;"}Hans
> *el.* Hendes
> Majestæt[)]{style="font-weight: normal; font-style: normal;"}

> R. [(dvs.
> ]{style="font-weight: normal; font-style: normal;"}ridder[)]{style="font-weight: normal; font-style: normal;"}

#### (4) Forkortelser med punktum

De fleste forkortelser der indeholder forkortelsespunktum, og som ikke
er proprier, skrives med små bogstaver, fx

> a.m.b.a., adr., dvs., f.eks., hr., m.v. *el.* mv., okt., osv., tlf.

Om brug af punktum i forkortelser, se i øvrigt § 42.

#### (5) Andre forkortelser og bogstavord

##### (a) Grundstoffer

Forkortelser for grundstoffer og deres forbindelser skrives med stort
begyndelsesbogstav:

> H, He, Na, Cl, NaCl

##### (b) Toner og tonearter

Durtonearterne skrives med stort begyndelsesbogstav, moltonearterne med
lille begyndelsesbogstav:

> D-dur, Des-dur, a-mol, as-mol

I sammensætninger skrives tonernes navne som regel med stort
begyndelsesbogstav, fx

> C-trompet, Es-klarinet, F-nøgle, E-streng

Udenfor sammensætninger skrives de som regel med lille
begyndelsesbogstav, fx

> enstreget a

> det høje c

> treklangen d-fis-a

##### (c) Former

Bogstaver der illustrerer formen på det de står for, skrives som store
bogstaver:

> I-jern, T-shirt, U-rør, V-udskæring, T-kryds, vej-T

##### (d) Rækkefølge og kvalitet mv.

Bogstaver der betegner rækkefølge, kvalitet, gruppe eller type, skrives
normalt som store bogstaver:

> A-rytter, A-menneske, A-hold, hold A, AB rhesuspositiv, B-film,
> B-skat, C-vitamin, vitamin C, Bx-tog, liste E, opgang H, 3. A, 1. V

§ 15-17. Orddeling ved linjeskift {#orddeling-ved-linjeskift xmlns="http://www.w3.org/1999/xhtml" h="http://www.w3.org/1999/xhtml"}
=================================

### § 15. Almindelige retningslinjer

Orddeling ved linjeskift markeres ved hjælp af en bindestreg (jf. § 57)
sidst på linjen. Ved orddeling i forbindelse med apostrof eller
skråstreg deles der efter apostroffen eller skråstregen, jf. § 6.7 og §
60.6. Ved parentes deles der før en begyndelsesparentes og efter en
slutparentes, jf. § 56.4. Ved anførselstegn deles der før et indledende
anførselstegn og efter et afsluttende anførselstegn, jf. § 58.5.

#### (1) Et praktisk hjælpemiddel

Orddeling er et hjælpemiddel til at overholde en bestemt linjelængde.
Det er således praktisk at ord kan deles på forskellige, men lige
korrekte, måder, fx

> må-lingerne, mål-ingerne, målin-gerne, måling-erne, målinger-ne.

Undertiden kan det være enklere at forklare hvordan et ord ikke må
deles, end hvordan det må deles.

#### (2) Mindst én vokal på hver linje

Når ord deles, skal der være mindst én vokal på hver linje. Man kan
derfor ikke dele enstavelsesord som fx blomst, hingst, hugst, mindst,
springsk, strengt, og af samme grund er orddelinger som fx »gedeha-ms«,
»gevin-st« og »st-række« ikke korrekte.

Flerstavelsesord deles normalt så der kommer til at stå to eller flere
bogstaver på hver linje. Men også orddelinger med kun ét bogstav (en
vokal) først eller sidst på linjen kan være korrekte, fx a-moralsk,
seng-e, trope-ø, u-lykke, å-bred. Orddelinger med kun ét bogstav først
på linjen er dog ofte unødvendige eftersom delestregen fylder (næsten)
lige så meget som et bogstav.

#### (3) Konsonantforbindelser

##### (a) Sidst på linjen

Et ord må ikke deles sådan at der sidst på en linje kommer til at stå en
konsonantforbindelse som normalt ikke forekommer sidst i et ord (jf. dog
§ 16.1.a og § 17.2.b). Følgende orddelinger er altså ikke korrekte:

> »forvitr-ing«, »hatt-en«, »parall-elle«, »supp-leant«.

##### (b) Først på linjen

Et ord må ikke deles sådan at der først på en linje kommer til at stå en
konsonantforbindelse som normalt ikke forekommer først i et ord (jf. dog
§ 16.1.a og § 17.2.b). Følgende orddelinger er altså ikke korrekte:

> »che-cken«, »ho-psa«, »sa-nger«, »su-pplere«.

#### (4) To slags orddelingsregler

Reglerne for deling af ord ved linjeskift er af to forskellige typer.
Den ene bygger på et princip om at man så vidt muligt skal dele mellem
betydningsbærende orddele, mens den anden er uafhængig af orddelenes
betydning.

Princippet om orddeling mellem betydningsbærende orddele er
hovedprincippet når man skal dele sammensatte ord (se nærmere § 16.1.a).
Ved deling af afledninger og bøjningsformer kan man i højere grad vælge
om man vil dele mellem betydningsbærende orddele (se nærmere § 16.1.b-§
16.1.d), eller om man vil undlade at tage hensyn til betydningen (se
nærmere § 17). Orddelingsangivelserne i ordbogens alfabetiske del følger
princippet om orddeling uafhængigt af betydningen.

### § 16. Orddeling ved betydningsbærende orddele

#### (1) Tilladte orddelinger

Sammensætninger, afledninger og bøjningsformer kan som hovedregel deles
mellem deres betydningsbærende orddele. Der kan således deles (a) mellem
sammensætningsled, (b) efter præfikser, (c) foran suffikser og (d) foran
bøjningsendelser.

##### (a) Mellem sammensætningsled

Eksempler på tilladte orddelinger:

> bage-pulver, grill-bar, halv-abe, intim-sfære, kakkel-ovn, lande-vej,
> mælke-karton, rosen-olie, rød-øjet, skibs-øl, skole-psykolog,
> spejl-æg, spå-kvinde, studenter-eksamen, syv-armet, tre-enighed,
> træk-vind, udviklings-tendens.

##### (b) Efter præfiks

Eksempler på tilladte orddelinger:

> an-klage, a-typisk, be-svare, be-undre, bi-falde, des-orienteret,
> eks-portere, er-kende, for-stå, fore-skrive, ge-bærde, gen-part,
> in-direkte, mis-tænkelig, sam-handel, u-gerning, und-gå, ur-komisk,
> van-ære.

##### (c) Foran suffiks

Eksempler på tilladte orddelinger:

> [Foran suffiks der begynder med
> konsonant:]{style="font-weight: normal; font-style: normal;"}
> astro-logi, bispe-dømme, demo-krati, far-lig, femino-logi,
> forsøgs-vis, frede-lig, gru-som, hellig-dom, hæv-ning, køns-lig,
> lys-ne, læng-de, mand-haftig, slug-vorn, stands-mæssig, styr-bar,
> syer-ske, triv-sel, tro-skab, uviden-hed, værktøjs-mager, yng-ling.

> [Foran suffiks der begynder med
> vokal:]{style="font-weight: normal; font-style: normal;"} arv-ing,
> baron-esse, bestyr-else, blod-ig, dyr-isk, dyrplag-eri, fjog-et,
> grev-inde, grin-agtig, kommun-isme, lak-ere, moral-isere, naz-isme,
> støvsug-er, telefon-ere, vid-en.

Afledninger med suffiks der begynder med en vokal, kan desuden deles
efter reglerne i § 17 om orddeling uafhængigt af betydningen, fx
besty-relse, kommu-nisme, la-kere. Undtaget herfra er dog afledninger
med suffikserne ‑agtig og ‑inde.

##### (d) Foran bøjningsendelse

Eksempler på tilladte orddelinger:

> deling-erne, delinger-ne, frist-ede, gevinst-en, hæng-er, klar-est,
> mand-en, rød-ere, skib-et, sug-ende.

Ord med bøjningsendelse kan desuden deles efter reglerne i § 17 om
orddeling uafhængigt af betydningen, fx ski-bet, man-den, fris-tede,
fri-stede.

#### (2) Ikketilladte orddelinger

I de fleste af de ord der består af flere betydningsbærende orddele, må
der ikke deles så et enkeltbogstav eller en konsonantgruppe skilles fra
den betydningsbærende orddel hvor de hører til. Det gælder (a) i
sammensætninger, (b) i afledninger med præfiks og (c) i visse
afledninger med suffiks (se nærmere nedenfor). Bindebogstaver regnes med
til ordets første del.

##### (a) Sammensætninger

Eksempler på ikketilladte orddelinger:

> »ang-stanfald«, »fer-skrøget«, »hal-vabe«, »land-evej«, »rose-nolie«,
> »rø-døjet«, »skib-søl«, »spej-læg«, »sy-varmet«, »træ-kvind«.

##### (b) Afledninger med præfiks

Eksempler på ikketilladte orddelinger:

> »ank-lage«, »bes-vare«, »de-sorienteret«, »for-eskrive«, »fors-tå«,
> »mi-stænkelig«.

##### (c) Visse afledninger med suffiks

Eksempler på ikketilladte orddelinger i afledninger med suffiks der
begynder med konsonant, eller med suffikserne ‑agtig eller ‑inde:

> »farl-ig«, »fred-elig«, »gri-nagtig«, »gu-dinde«, »hovedstad-sagtig«,
> »hævn-ing«, »køn-slig«, »mors-om«, »tros-kab«.

Der kan heller ikke deles »forvitr-ede«, »forvitr-ing«, »hatt-en«,
»hakk-else«, »pige-r«, »stør-st«, jf. § 15.2.

### § 17. Orddeling uafhængigt af betydningen

Mange ord deles uafhængigt af betydningen. Det gælder fx to- og
flerstavelsesord der ikke består af stavelser med hver sin betydning:

> allike, billede, doven, huske, mandarin, peber, pige, stjerne.

Og det kan gælde to- og flerstavelsesord der ikke umiddelbart erkendes
som sammensatte eller afledte ord:

> alene, erindre, hustru, vindue.

Reglerne for orddeling uafhængigt af betydningen kan også bruges ved
deling af afledninger med suffiks der begynder med vokal (undtagen
‑agtig og ‑inde), jf. § 16.1.c, og ved deling af bøjningsformer, jf. §
16.1.d.

#### (1) Deling ved vokaler

Der kan deles mellem vokaler der hører til hver sin stavelse:

> di-æt, du-et, fi-asko, pæ-on, re-elt, spi-on, tre-er, virtu-os.

Der må ikke deles mellem to eller flere vokaler som hører til samme
stavelse, og som står umiddelbart ved siden af hinanden. Man kan derfor
ikke dele enstavelsesord som fx gear, plaid, sheik, speed, toast, yacht,
og af samme grund er følgende orddelinger ikke korrekte:

> »bure-auet«, »burea-uet«, »co-aster«, »do-uchen«, »ge-aret«,
> »ne-utralitet«, »pa-use«, »spe-edometer«.

Der kan dog deles mellem et -ti- og -si- udtalt som *sj* og en
efterfølgende vokal, fx

> akti-er, ambiti-øst, pati-ent, stati-onen; diskussi-on, læsi-oner.

#### (2) Deling ved konsonanter

I ord med én eller flere konsonanter mellem vokaler deles der som
hovedregel foran den sidste (eller eneste) konsonant.

##### (a) Enkelt konsonant mellem vokaler

I ord med en enkelt konsonant mellem vokaler deles der som hovedregel
foran denne konsonant:

> a-lene, ba-jer, besty-relse, blo-dig, dy-risk, e-rindre, fjo-get,
> pe-ber, pi-ge, støvsu-ger, telefo-nere, vi-den.

##### (b) Konsonantgruppe mellem vokaler

I ord med en konsonantforbindelse mellem vokaler deles der som
hovedregel foran den sidste konsonant i forbindelsen:

> ar-ving, bul-der, eks-pert, gis-pe, kas-ket, mes-sing, plad-sen,
> san-ger, stjer-ne, tas-ke, tørs-te, æb-le.

Der deles dog fx ag-gressiv, ak-klimatisere og sup-pleant (ikke
»agg-ressiv«, »akk-limatisere« og »supp-leant«, jf. § 15.3.a).

I ord med en konsonantforbindelse mellem vokaler kan der desuden deles
foran så mange konsonanter som almindeligt kan stå først i et ord:

> an-drik, anti-kveret, cim-brisk, dan-skerne, disci-plin, di-skret,
> elek-trisk, ero-bre, fa-brik, foræl-dre, gi-spe, ham-stre, indu-stri,
> ka-sket, kate-dral, ma-dras, or-dre, por-træt, pro-blem, se-kretær,
> ta-ske, tør-ste, vin-tre, æ-ble.

Der kan dog ikke deles foran konsonanter som i udtalen af det pågældende
ord klart hører til hver sin stavelse. Følgende orddelinger er således
ikke korrekte:

> »a-djunkt«, »be-dre«, »ha-gle«, »ma-gnolie«, »mind-re«, »re-gne«,
> »sme-dje«, »te-knik«.

Konsonantforbindelserne ch, ck, dh, gh, sc, sch, sh og sj deles ikke når
konsonanterne hører til samme stavelse. Følgende orddelinger er derfor
ikke korrekte:

> »bols-je«, »broc-hen«, »budd-hisme«, »chec-ken«, »dis-ciplin«,
> »douc-he«, »fas-cisme«, »geis-ha«, »gullas-chen«, »gullasc-hen«,
> »hoc-key«, »spag-hetti«, »Stuc-kenberg«.

> [(Derimod: ]{style="font-weight: normal; font-style: normal;"}bol-sje,
> bro-chen, bud-dhisme, check-en, di-sciplin, dou-che, fa-scisme,
> gei-sha, gulla-schen, hock-ey, spa-ghetti,
> Stuck-enberg[)]{style="font-weight: normal; font-style: normal;"}.

§ 18-19. Ét eller flere ord? {#ét-eller-flere-ord xmlns="http://www.w3.org/1999/xhtml" h="http://www.w3.org/1999/xhtml"}
============================

### § 18. Skrivemåden afhængig af udtalen

Om en ordforbindelse skal skrives i ét eller to (eller flere) ord,
afhænger som hovedregel af hvordan forbindelsen udtales (om undtagelser,
se § 19).

#### (1) I ét ord

Hvis en ordforbindelse udtales med hovedtryk (stærkt tryk) på det første
led og bitryk (svagere tryk) på det andet, skrives forbindelsen i ét
ord:

> havestol, hvidtøl, kæmpehøj, landevej, medbestemmelse, senildement,
> statsansat, sursød, systemanalyse, teaterforestilling, underskrive.

Det gælder også forbindelser af ord der i sig selv består af
ordforbindelser:

> ansvarsforsikringspolice, betonblandemaskine, fodgængerovergang,
> fædrelandskærlig, langtidsplanlægge, tjenestemandsansat,
> øretæveindbydende.

Om brug af bindestreg i sammensætninger som fx rød-hvid, se § 57.5.

#### (2) I flere ord

Hvis en ordforbindelse udtales med lige stærkt tryk på begge led,
skrives den i to (eller flere) ord:

> Aluminium er et meget let metal *(Men: *letmetallet aluminium*)*.

> Organisationerne har for stor magt *(Men: *stormagten Kina*)*.

> Klokken var halv syv *(Men: *Flasken var halvtom*)*.

> Vi fik tilbudt 20 % rabat *(med bogstaver: *tyve procent rabat*) el.*
> 20 %'s rabat *(med bogstaver: *tyve procents rabat*)* på varerne.
> *(Men: *Vi fik tilbudt en 20-%-rabat *(med
> bogstaver: *tyveprocentrabat*) el.* en 20-%'s-rabat *(med
> bogstaver: *tyveprocentsrabat*)* på varerne*)*.

#### (3) To udtaler -- to skrivemåder

Undertiden kan en ordforbindelse udtales med forskelligt tryk uden at
betydningen ændres. I sådanne tilfælde er det både tilladt at skrive i
ét og i flere ord:

> en kæmpesucces *el.* en kæmpe succes [(se også §
> 19.3)]{style="font-weight: normal; font-style: normal;"}

> et femkronersfrimærke *el.* et femkroners frimærke [(se også §
> 19.4)]{style="font-weight: normal; font-style: normal;"}

> den tilgrundliggende hypotese *el.* den til grund liggende hypotese

> et tyndtbefolket område *el.* et tyndt befolket område

> De har hidtil haft fællesøkonomi *el.* fælles økonomi.

Om brug af bindestreg, se § 57.

#### (4) Firmanavn, varemærke e.l. som førsteled

Forbindelser med et firmanavn, varemærke e.l. som førsteled skrives
efter samme regler som andre ordforbindelser, dvs. afhængigt af udtalen.

Hvis forbindelsen udtales med hovedtryk + bitryk, skrives den i ét ord.
En sådan udtale forekommer især i forbindelser med et relativt let
andetled, fx

> Volvomodel, Tuborgøl, Zippolighter, Webergrill, Veluxvindue, PH-lampe.

Hvis forbindelsen udtales med lige stærkt tryk på de to led, skrives den
i to ord. En sådan udtale forekommer især i forbindelser med et relativt
tungt andetled, fx

> Tuborg jubilæumsøl

> Velux ovenlysvindue

> PH udendørslampe

> Philips infrarød muskelafspændingslampe

> Pinotex heldækkende træbeskyttelse.

Men i en del tilfælde er der to udtaler med to tilsvarende skrivemåder,
fx

> Samsungmobiltelefon *el.* Samsung mobiltelefon

> Philipsstrygejern *el.* Philips strygejern

> Weberkuglegrill *el.* Weber kuglegrill.

Når sådanne forbindelser har bøjningsendelse, skrives de normalt i ét
ord, fx

> Weberkuglegrillen, PH-udendørslamperne.

Om brugen af store og små bogstaver i sammensætninger med proprium som
førsteled, se § 12.10. Om brugen af bindestreg i usædvanlige
sammensætninger, se § 57.8.

### § 19. Skrivemåden uafhængig af udtalen

Om en ordforbindelse skrives i ét eller flere ord, kan ikke altid
udledes af udtalen. Skrivemåden afhænger da undertiden af forbindelsens
grammatiske funktion eller dens betydning, men som regel er der blot
tale om en hævdvunden praksis.

#### (1) Adverbium + præposition

Forbindelser af adverbier og præpositioner skrives som hovedregel i to
ord når præpositionen har en styrelse, ellers i ét ord:

##### (a) Med styrelse

Når præpositionen har en styrelse, skrives forbindelsen som hovedregel i
to ord:

> De har altid haft svært ved at komme ud ad døren i ordentlig tid.

> Plæneklipperen kører op til 4 timer på en opladning.

> Hun er cyklet hjem efter sit badetøj.

> Ude fra gaden lød der et stort brag.

> Vejen gik stejlt op ad bakke.

> Vi skal mødes henne på torvet.

En række forbindelser er i Retskrivningsordbogen opført både som
særskrevne forbindelser (flerordsforbindelser) og som sammenskrevne
forbindelser (præposition og adverbium), fx

in\|den for; inden for el. indenfor døren (jf. § 19.1.a)in\|den\|for
præp., adv.; indenfor el. inden for døren (jf. § 19.1.a); kom indenfor!
(jf. § 19.1.b)

Sådanne forbindelser kan valgfrit skrives i ét eller to ord når de har
en styrelse (dvs. bruges som præpositioner):

> Stil skoene uden for *el.* udenfor døren!

> Ham kan vi ikke stille noget op over for *el.* overfor.

> Hun er ekspert inden for *el.* indenfor sit område.

> Jakken hænger bag ved *el.* bagved døren.

> De større byer kører vi altid uden om *el.* udenom.

> Ud over *el.* Udover bestyrelsen var ingen med.

Følgende forbindelser kan skrives i ét eller to ord når de har en
styrelse:

> bag efter *el.* bagefter

> bag i *el.* bagi

> bag om *el.* bagom

> bag på *el.* bagpå

> bag ved *el.* bagved

> inden for *el.* indenfor

> inden i *el.* indeni

> inden om *el.* indenom

> inden under *el.* indenunder

> neden for *el.* nedenfor

> neden om *el.* nedenom

> neden under *el.* nedenunder

> oven for *el.* ovenfor

> oven i *el.* oveni

> oven om *el.* ovenom

> oven over *el.* ovenover

> oven på *el.* ovenpå

> over for *el.* overfor

> uden for *el.* udenfor

> uden om *el.* udenom

> uden over *el.* udenover

> uden på *el.* udenpå

> ud over *el.* udover.

Som det fremgår af listen, drejer det sig i hovedsagen om forbindelser
hvis første led er et adverbium der ender på ‑en (inden, neden, oven,
uden) eller adverbiet bag.

Enkelte forbindelser der normalt kun optræder med styrelse, kan
ligeledes valgfrit skrives i ét eller to ord. Sådanne forbindelser er i
Retskrivningsordbogen opført både som særskrevne forbindelser
(flerordsforbindelser) og som sammenskrevne forbindelser (præposition),
fx

frem for; træde frem for el. fremfor kongen; frem for alt el. fremfor
alt (jf. § 19.1.a)frem\|for præp.; træde fremfor el. frem for kongen;
fremfor alt el. frem for alt (jf. § 19.1.a)

Det drejer sig om følgende forbindelser:

> frem for *el.* fremfor

> hen ad *el.* henad

> hen imod *el.* henimod

> hen under *el.* henunder

> hen ved *el.* henved.

##### (b) Uden styrelse

Når sådanne forbindelser af adverbier og præpositioner bruges som
adverbier (dvs. uden styrelse), skrives de i ét ord:

> Stil skoene udenfor!

> Bor der ingen i huset overfor?

> Døren åbner udad.

> Fremover må du passe bedre på.

> Om bagved med dig!

> Han sendte bolden indover med stor kraft.

> Kom indenfor!

> Porten kan kun låses udefra.

> Skibet tog kurs udover.

> Vejen gik stejlt opad.

> Du bliver nødt til at køre udenom.

> Drys salt henover.

Forbindelser der kan optræde uden styrelse (dvs. bruges som adverbier),
er i Retskrivningsordbogen opført som præposition og adverbium eller som
adverbium alene, fx

in\|den\|for præp., adv.; indenfor el. inden for døren (jf. § 19.1.a);
kom indenfor! (jf. § 19.1.b)bag\|til adv.; dåbskjolen er åben bagtil

#### (2) Betydningsforskel

Der kan ikke gives faste regler for hvornår betydningen af en
ordforbindelse afgør om den skal skrives i ét eller flere ord. Men nogle
eksempler kan illustrere forholdet:

> Barnet puttede sig ind til sin far.\
> Udsalget varer indtil den 5. november.

> Kør helt ind til kantstenen!\
> Kan jeg køre med indtil Roskilde?

> Ingen ved hvor vidt han kunne have bragt det.\
> Der er tvivl om hvorvidt regeringen holder skansen.

> Forklaringen gik hen over hovedet på de fleste.\
> Har han overhovedet sat sig ind i sagen?

> Det er vist nok med én.\
> Hun er vistnok ikke hjemme.

#### (3) Forstærkende førsteled

Forbindelser med forstærkende førsteled skrives som hovedregel i ét ord
selvom de udtales med lige stærkt tryk på begge led:

> allerbedst, dødsensfarlig, dødtræt, ekstrablød, hundekoldt, megastor,
> platumulig, smadderærgerligt, snotforkølet, superlækkert,
> ærkereaktionær, øsregne.

Visse af de forstærkende førsteled er tillige opført i
Retskrivningsordbogens opslagsdel som selvstændige opslagsord. De kan
nemlig også fungere som adjektiver (oftest ubøjelige) og dermed indgå i
ordforbindelser der skrives i flere ord. Det gælder fx kæmpe i
betydningen 'kæmpemæssig', fx en kæmpe socialdemokratisk sejr, og mega,
fx en mega skattefri milliongevinst.

#### (4) Talord

Talord under 100 skrives i ét ord:

> fyrretyve, halvanden, halvtredje, halvtreds, femogtresindstyvende,
> femti, firti, nitisyv, treogfyrre, tresindstyve.

Talord over 100 deles op:

> to hundred *(el. *to hundrede*)*

> to hundred (og) tre *(el. *to hundrede (og) tre*)*

> to hundred (og) niogtyve *(el. *to hundrede (og) niogtyve*)*

> tre tusind to hundred (og) niogtyve *(el. *tre tusinde to hundrede
> (og) niogtyve*)*

> tre tusind og tyve *(el. *tre tusinde og tyve*)*

> den to hundred (og) niogtyvende *(el. *den to hundrede (og)
> niogtyvende*)*

> nitten hundred (og) nioghalvfems *(el. *nitten hundrede (og)
> nioghalvfems*)*.

Betegnelser på brøker skrives adskilt fra resten af talordet, fx
treogfyrre (og) en halv, to hundrede (og) trekvart.

I to ord skrives hver anden, hvert andet, hver *el.* hvert tredje, hver
*el.* hvert fjerde osv.

Skrivemåden af forbindelser med ord som femkroners, treværelsers mv.
følger hovedreglen i § 18 og retter sig efter udtalen. Det betyder at
ordforbindelser der har to gængse udtaler, også kan skrives på to måder:

> et femkroners frimærke *el.* et femkronersfrimærke

> et 5-kr.s frimærke [(jf. § 57.4)
> ]{style="font-weight: normal; font-style: normal;"}*el.* et
> 5-kr.s-frimærke [(jf. §
> 57.4)]{style="font-weight: normal; font-style: normal;"}

> en etbinds udgave *el.* en etbindsudgave

> et firemotorers fly *el.* et firemotorersfly

> en attenårs fødselsdag *el.* en attenårsfødselsdag

> en 18-års fødselsdag [(jf. § 57.4)
> ]{style="font-weight: normal; font-style: normal;"}*el.* en
> 18-årsfødselsdag [(jf. §
> 57.4)]{style="font-weight: normal; font-style: normal;"}

> en 200-km's grænse [(jf. § 57.4)
> ]{style="font-weight: normal; font-style: normal;"}*el.* en
> 200-km's-grænse [(jf. §
> 57.4)]{style="font-weight: normal; font-style: normal;"}

> en topersoners bil *el.* en topersonersbil

> en femårs dreng *el.* en femårsdreng.

#### (5) *Simpelthen* og *simpelt hen* mfl.

Følgende ordforbindelser kan uden forskel i udtale eller betydning
skrives i ét eller flere ord:

> afsted *el.* af sted

> allesammen *el.* alle sammen

> alletiders *el.* alle tiders

> allevegne *el.* alle vegne

> etcetera *el.* et cetera

> forresten *el.* for resten

> glatvæk *el.* glat væk

> gudbevares *el.* gud bevares

> gudhjælpemig *el.* gud hjælpe mig

> gudskelov *el.* gud ske lov

> herregud *el.* herre gud

> hertillands *el.* her til lands

> immerhen *el.* immer hen

> immervæk *el.* immer væk

> ingensinde *el.* ingen sinde

> ingenting *el.* ingen ting

> nogensinde *el.* nogen sinde

> ombord *el.* om bord

> omend *el.* om end

> raskvæk *el.* rask væk

> selvom *el.* selv om

> selvsamme *el.* selv samme

> sidenhen *el.* siden hen

> simpelthen *el.* simpelt hen

> sommetider *el.* somme tider

> stadigvæk *el.* stadig væk

> såvel (.. som) *el.* så vel (.. som)

> tidsnok *el.* tids nok

> tilfælles *el.* til fælles

> tillykke *el.* til lykke.

#### (6) .. *som helst*

Forbindelser med som helst skrives i tre ord:

> hvad som helst

> hvem som helst

> hvilken (hvilket, hvilke) som helst

> hvor som helst

> ingen (intet) som helst

> nogen (noget) som helst

> når som helst.

§ 20-39. Bøjningsforhold {#bøjningsforhold xmlns="http://www.w3.org/1999/xhtml" h="http://www.w3.org/1999/xhtml"}
========================

§ 20-24. Substantiver
---------------------

### § 20. Fælleskøn eller intetkøn?

#### (1) Substantiver med ét grammatisk køn

De fleste substantiver har kun ét grammatisk køn: fælleskøn eller
intetkøn. De enkelte ords køn fremgår i hvert enkelt tilfælde af
Retskrivningsordbogens opslagsdel, fx

kan\|ni\|bal sb., -en, -er, -erneflag sb., -et, flag, -ene, i sms.
flag-, fx flaghejsning

#### (2) Fælleskøn eller intetkøn uden betydningsforskel

Nogle substantiver kan være fælleskøn eller intetkøn uden at betydningen
ændres. Det gælder fx bacon, fond (kapital; legat, stiftelse), insulin,
katalog. Sådanne ord er i Retskrivningsordbogens opslagsdel anført på
følgende måde:

ba\|con sb., baconen el. baconet, i sms. bacon-, fx baconsvin,
baconsvøb, baconternin\|su\|lin sb., insulinen el. insulinet, i sms.
insulin-, fx insulinsprøjte

#### (3) Forskelligt køn -- forskellig betydning

I nogle tilfælde svarer det ene køn til én betydning, det andet til en
anden betydning. Ord med forskelligt køn og forskellig betydning er i
Retskrivningsordbogen behandlet hver for sig, fx

ja\|lou\|si sb., -en (skinsyge), i sms. jalousi-, fx
jalousiopgørja\|lou\|si sb., -et, -er, -erne (skærm af tynde lister), i
sms. jalousi-, fx jalousidørvår sb., -en (forår), i sms. vår-, fx
vårdag, vårraps, vårsildvår sb., -et, vår, -ene (overtræk til dyner og
puder)

#### (4) Stoffer, masser og væsker

Substantiver der betegner stoffer, masser eller væsker, har ofte vekslen
mellem fælleskøn og intetkøn. Til denne vekslen i køn kan der i større
eller mindre grad svare en vekslen i betydning:

##### (a) Fælleskøn om bestemt art eller mængde

Nogle intetkønsord der betegner stoffer eller masser, kan være fælleskøn
når de bruges om en bestemt art eller kvalitet eller om en afgrænset
mængde af stoffet, fx

> Det var en god og kraftig lærred.

> Denne ler er særlig velegnet til fremstilling af drænrør.

> Skal al den dejlige fedt virkelig gå til spilde?

En sådan brug af fælleskøn til at betegne en bestemt art e.l. er
principielt mulig ved de fleste ord der betegner stoffer eller masser.
Brugen forekommer ofte i mere fagligt eller branchepræget sprog og er
ikke nævnt under de enkelte intetkønsord i ordbogen. At et ord der
betegner et stof eller en masse, kun er anført som intetkønsord i
ordbogen, udelukker altså ikke at det i særlige tilfælde kan bruges som
fælleskønsord.

##### (b) Fælleskøn eller intetkøn uden betydningsforskel

Andre af de ord der betegner stoffer, masser eller væsker, kan være
fælleskøn eller intetkøn uden særlig betydningsforskel (jf. § 20.2
ovenfor). Det gælder fx gummi, kanel, klister, klor, opium, ral, tegl,
tran. Også ved sådanne ord kan intetkøn dog bruges om det pågældende
stof som sådant, mens fælleskøn kan bruges om en bestemt art eller om en
afgrænset mængde (fx Denne gummi er ekstra slidstærk). Disse ord er
anført i Retskrivningsordbogens opslagsdel med valgfrit køn, fx

gum\|mi sb., gummien el. gummiet, -er, -erne, i sms. gummi-, fx
gummihandske

##### (c) Intetkøn + fælleskønsord

Visse fælleskønsord kan kombineres med foranstillede intetkønsord som
det, noget, meget, andet når de bruges om en utællelig mængde, fx

> Vil du straks tørre det mælk op!

> Hun kunne starte sin egen planteskole med alt det jord hun har under
> neglene.

> Vi har noget familie i Jylland.

> Har du hørt noget god *el.* godt musik for nylig?

> Vi har ikke meget maling tilbage.

> Har I ikke fået andet mad i dag?

> Jeg har ventet i noget tid.

Denne særlige brug af intetkøn er ikke anført ved de enkelte
fælleskønsord i Retskrivningsordbogen.

### § 21. Genitiv

#### (1) Hovedregel

Genitiv ender som hovedregel på ‑s:

> døgnets middeltemperatur

> biernes liv

> min brors fødselsdag

> Amerikas opdagelse

> Provences befolkning

> Hartvig Frischs retskrivningsreform

> Brüel & Kjærs personale

> Alices restaurant

> Bachs dobbeltkoncert

> John Miltons digte.

#### (2) Ord på -*s*, -*x* eller -*z*

Ord der ender på ‑s, ‑x eller ‑z, har genitiv på ' (apostrof, jf. § 6):

> Calais' beliggenhed

> cornflakes' sukkerindhold

> dette hus' indretning

> en jordbæris' smag

> Jacques' lillesøster

> Randers' erhvervsliv

> Sofus' fødselsdag

> en bordeaux' duft

> Marx' skrifter

> den moderne jazz' udvikling.

#### (3) Forkortelser

##### (a) Med forkortelsespunktum

Forkortelser der ender på forkortelsespunktum, har genitiv på -s:

> afs.s navn og adresse

> en cand.mag.s beskæftigelsesmuligheder

> Chr. 4.s regeringstid *(men: *Chr. IV's[, jf. §
> 42.3]{style="font-weight: normal; font-style: normal;"}*)*.

##### (b) Uden forkortelsespunktum

Forkortelser der skrives uden forkortelsespunktum, har genitiv på 's:

> it's *(el. *IT's*)* fordele

> tv's *(el. *TV's*)* underholdningsprogrammer

> 2 cm's mellemrum

> USA's præsident

> borger.dk's brugere.

Når sådanne forkortelser kan udtales som egentlige ord, kan de dog også
tilføje ‑s direkte:

> epos *(el. *epo's*)* virkning

> Natos *el.* NATOs *(el. *Nato's *el.* NATO's*)* generalsekretær.

Forkortelser der ender på ‑s, ‑x eller ‑z, har genitiv på ' (apostrof):

> aids' følger

> SAS' personale

> Jensen A/S' overskud

> Føtex' kundekreds.

#### (4) Taltegn, symboler, citatord mv.

Om brug af 's på taltegn, symboler og citatord mv., se § 6.2.

### § 22. Substantiver med fremmede pluralisendelser

Der kan ikke gives helt faste regler for hvordan man danner bestemt form
pluralis af substantiver der i ubestemt form pluralis har (eller kan
have) en fremmed pluralisendelse (især ‑i, ‑a og ‑s, fx konti,
periodika, jobs). Det tilrådes derfor at man først og fremmest søger
oplysninger om bestemt form pluralis under de enkelte ord i selve
ordbogen. Ved ord hvor ordbogen ikke oplyser om bestemt form pluralis,
og ved ord der ikke er med i ordbogen, anbefales det at følge
nedenstående retningslinjer.

Bestemt form pluralis af substantiver med fremmede pluralisendelser kan
dog virke afstikkende og kan undertiden erstattes af andre
formuleringer, fx disse jokes (i stedet for jokesene) og mine sneakers
(i stedet for sneakersene).

#### (1) Substantiver med pluralis på -*i* eller -*a*

Substantiver der i ubestemt form pluralis ender på ‑i eller ‑a, danner
bestemt form pluralis ved at få tilføjet endelsen ‑ene til den ubestemte
pluralisform:

> modi -- modiene

> fakta -- faktaene

> periodika -- periodikaene.

Nogle gange har sådanne substantiver en dansk pluralisendelse ved siden
af den fremmede. I disse tilfælde er der to muligheder for at danne
bestemt form pluralis:

> konti -- kontiene *el.* kontoer -- kontoerne

> leksika -- leksikaene *el.* leksikoner -- leksikonerne.

#### (2) Substantiver med pluralis på -*s*

Substantiver der i ubestemt form pluralis kan ende på ‑s, har
forskellige muligheder for at danne bestemt form pluralis. Det afhænger
bl.a. af om ‑s er den eneste mulige pluralisendelse, eller om der også
kan bruges danske pluralisendelser:

##### (a) Kun -*s*

Substantiver der i ubestemt form pluralis kun kan have endelsen ‑s, har
i bestemt form endelsen ‑ene. Ved nogle af disse ord bortfalder s'et
foran ‑ene:

> keyboards -- keyboardene

> skærmdumps -- skærmdumpene.

Men ved andre bevares s'et foran endelsen:

> jeans -- jeansene

> fans -- fansene.

##### (b) Både -*s* og -*er*

Substantiver der i ubestemt form pluralis foruden ‑s kan have den danske
endelse ‑er, kan altid danne bestemt form pluralis ved at tilføje
endelsen ‑ne til formen på ‑er. Nogle substantiver kan kun danne bestemt
form på denne måde:

> cups/cupper -- cupperne.

Andre kan desuden danne bestemt form pluralis med endelsen ‑ene og med
bortfald af ‑s foran denne endelse:

> slogans/sloganer -- sloganene/sloganerne.

Ved visse substantiver er der dog ikke nødvendigvis bortfald af ‑s foran
endelsen ‑ene:

> apps/apper -- appsene/apperne.

##### (c) Både -*s* og ingenting

Substantiver der i ubestemt form pluralis foruden at have ‑s kan være
uden endelse, danner ofte bestemt form pluralis med endelsen ‑ene:

> jobs/job -- jobbene

> shows/show -- showene.

Men ved sådanne ord kan der desuden dannes en bestemt form pluralis hvor
s'et er bevaret foran bestemthedsendelsen:

> chips/chip [(lille elektronisk kredsløb;
> spillemærke)]{style="font-weight: normal; font-style: normal;"} --
> chipsene/chippene

> shots/shot [(lille glas
> spiritus)]{style="font-weight: normal; font-style: normal;"} --
> shotsene/shottene.

### § 23. Substantiver på -*el*, -*en* og -*er*

I mange af de substantiver der ender på ‑el, ‑en eller ‑er, kan eller
skal ‑e- foran ‑l, ‑n eller ‑r stryges når ordet bøjes:

> gidsel -- gidslet -- gidsler

> figen -- figenen -- figner *el.* figener

> teater -- teatret *el.* teateret -- teatre.

Bemærk at der ikke kan stå to ens konsonanter foran ‑l, ‑n eller ‑r (jf.
§ 8.2):

> gaffel -- gaflen -- gafler

> offer -- ofret *el.* offeret -- ofre.

Der kan ikke gives faste regler for hvornår ‑e- stryges, og hvornår det
bevares. Det tilrådes derfor at man i tvivlstilfælde søger oplysninger
om bøjningsformer af disse ord under de enkelte ord i selve ordbogen.
Men hvis man vil undgå at slå op i ordbogen, kan man i de fleste
tilfælde benytte de nedenstående hjælperegler:

#### (1) Ord på -*el*

Langt de fleste ord på ‑el (med svagt tryk på denne stavelse) kan eller
skal skrives uden ‑e- i både singularis og pluralis:

> cykel -- cyklen -- cykler

> handel -- handlen *el.* handelen -- handler

> regel -- reglen -- regler

> taffel -- taflet *el.* taffelet -- tafler.

Det er således næsten altid korrekt at stryge ‑e- i ord på ‑el. Kun i de
følgende tilfælde skal ‑e- bevares:

> bagel -- bagelen -- bagels

> kennel -- kennelen -- kenneler

> label [(mærkat,
> etiket)]{style="font-weight: normal; font-style: normal;"} -- labelen
> -- labeler *el.* labels

> spaniel -- spanielen -- spanieler *el.* spaniels

> tunnel -- tunnelen *el.* tunnellen -- tunneler *el.* tunneller.

#### (2) Ord på -*en*

Langt de fleste ord på ‑en kan eller skal skrives med ‑e- i både
singularis og pluralis:

> aften -- aftenen -- aftner *el.* aftener

> køkken -- køkkenet -- køkkener

> lagen -- lagnet *el.* lagenet -- lagner *el.* lagener

> væsen -- væsnet *el.* væsenet -- væsner *el.* væsener.

Det er således som udgangspunkt korrekt at bevare ‑e- i ord på ‑en.

#### (3) Ord på -*er*

Alle ord på ‑er kan eller skal skrives med ‑e- i singularis:

> fætter -- fætteren

> monster -- monstret *el.* monsteret

> orkester -- orkestret *el.* orkesteret

> tiger -- tigeren.

En del af ordene på ‑er kan eller skal skrives uden ‑e- i pluralis:

> fætter -- fætteren -- fætre

> monster -- monstret *el.* monsteret -- monstre

> orkester -- orkestret *el.* orkesteret -- orkestre

> tiger -- tigeren -- tigre *el.* tigere.

De fleste af ordene på ‑er bevarer dog ‑e- i både singularis og
pluralis:

> bager -- bageren -- bagere

> læser -- læseren -- læserne

> sjællænder -- sjællænderen -- sjællændere.

Hvis man vil være på den sikre side med hensyn til bøjningen af et ord
på ‑er, må man derfor slå det op i ordbogen.

### § 24. Substantiver med pluralis på -*ere*

I substantiver der ender på ‑er, og som i ubestemt form pluralis ender
på bogstavfølgen ‑ere, bortfalder den ubestemte pluralisendelse ‑e foran
bestemthedsendelsen ‑ne:

> lærer -- lærere -- lærerne

> bager -- bagere -- bagerne

> odder -- oddere -- odderne

> rykker -- rykkere -- rykkerne.

§ 25-28. Adjektiver
-------------------

Om adjektiver dannet af præteritum participium, se § 35, og om
adjektiver brugt som adverbialer, se § 36-39.

### § 25. Adjektiver på -*el*, -*en* og -*er*

I adjektiver der ender på ‑el, ‑en eller ‑er, bortfalder ‑e- foran ‑l,
‑n eller ‑r når ordet får tilføjet en bøjningsendelse der begynder med
en vokal:

> ædel -- ædle -- ædlere -- ædlest

> moden -- modne -- modnere -- modnest

> mager -- magre -- magrere -- magrest

> fordrukken -- fordrukne.

Der kan ikke stå to ens konsonanter foran ‑l, ‑n eller ‑r (jf. § 8.2):

> gammel -- gamle

> rådden -- rådne

> sikker -- sikre -- sikrere -- sikrest.

### § 26. Adjektiver på -*sk*

De fleste af de adjektiver der ender på ‑sk, kan ikke tilføje endelsen
‑t i intetkøn. Det gælder også når adjektivet bruges som adverbial:

> et tysk ægtepar

> et persisk marked

> et fynsk bondehus

> et musikalsk eventyr

> et arkæologisk fund

> et økonomisk opsving

> et himmelsk måltid

> Hegnet er elektrisk.

> Systemet er automatisk.

Ved enstavelsesord der ikke betegner nationalitet eller geografisk
tilhørsforhold, og som ikke er afledninger til personnavne, kan man dog
valgfrit tilføje ‑t i intetkøn. Det gælder dermed også når adjektivet
bruges som adverbial:

> et lumsk *el.* lumskt smil

> fersk *el.* ferskt kød

> Hun gik rask *el.* raskt til.

> Smørret var harsk *el.* harskt.

> Øllet smagte besk *el.* beskt.

> Hun smilede skælmsk *el.* skælmskt.

Valgfriheden gælder også når sådanne enstavelsesord indgår i
sammensætninger og afledninger som fx menneskefjendsk, ufrisk, uhumsk.

Det er som nævnt valgfrit om man vil tilføje ‑t eller ej, og det er
således altid korrekt at lade være med at sætte ‑t på adjektiver der
ender på ‑sk.

### § 27. Adjektiver på -*vis*

Ved adjektiver der ender på ‑vis, er der i intetkøn valgfrihed mellem en
form med ‑t og en form uden ‑t:

> et delvis *el.* delvist nederlag

> Prisstoppet var oprindelig kun forsøgsvis *el.* forsøgsvist.

Også ved adjektiver på ‑vis brugt som adverbialer er der valgfrihed
mellem en form med ‑t og en form uden ‑t (jf. § 39). Rene adverbier på
‑vis har derimod aldrig ‑t (jf. § 36.1).

En undtagelse fra ovenstående er adjektivet næsvis, som altid har ‑t i
intetkøn.

> et næsvist svar.

Når næsvis bruges som adverbial, har det ligeledes ‑t:

> De svarede næsvist igen.

### § 28. Adjektiver på trykstærk vokal

#### (1) Hovedregel

Adjektiver der ender på en trykstærk vokal, er som hovedregel ubøjelige:

> et ru bræt

> den ru planke

> pligttro tjenere

> hans kry væsen.

#### (2) Ord på -*å* samt *ny* og *fri*

De adjektiver der ender på ‑å, får dog tilføjet ‑t i intetkøn og dermed
også når de bruges som adverbialer:

> blåt blod

> Vinden blæste råt.

Ordene ny og fri får ligeledes tilføjet ‑t i intetkøn og som
adverbialer:

> et nyt ur

> et rentefrit lån

> Han lånte 1000 kr. rentefrit.

I bestemt form singularis og i pluralis er det ved disse to ord valgfrit
om man vil tilføje ‑e eller ej:

> mit nye ur *el.* mit ny ur

> det frie ord *el.* det fri ord

> nye ord i dansk *el.* ny ord i dansk

> de isfrie farvande *el.* de isfri farvande.

§ 29-35. Verber
---------------

### § 29. Verber på trykstærk vokal

#### (1) Præsens og infinitiv

Verber som i infinitiv ender på en trykstærk vokal, falder i to
hovedgrupper. I den ene (a) føjes endelserne ‑r og ‑s direkte til den
trykstærke vokal uden at der indskydes et ‑e-. I den anden (b) kan der
indskydes et ‑e- foran ‑r og ‑s:

##### (a) Ord på -*e*, -*o*, -*æ*, -*ø* eller -*å*

Verber der i infinitiv ender på trykstærkt ‑e, ‑o, ‑æ, ‑ø eller ‑å, får
tilføjet endelserne ‑r og ‑s direkte til den trykstærke vokal:

> Det sner.

> Jeg bor her.

> Rugen drær.

> De dybfrosne grøntsager skal tøs op før brug.

> Bedre service fås ikke.

> Regnskabet må gås igennem en gang til.

##### (b) Ord på -*i*, -*u* eller -*y*

Verber der i infinitiv ender på trykstærkt ‑i, ‑u eller ‑y, får tilføjet
endelserne ‑r og ‑s direkte til den trykstærke vokal eller får indskudt
et ‑e-:

> Hun rir kjolen *el.* Hun rier kjolen.

> Det dur ikke *el.* Det duer ikke.

> De fornyr lånet *el.* De fornyer lånet.

> Saften sis *el.* Saften sies.

> Knappen sys i frakken *el.* Knappen syes i frakken.

> Lånet bør fornys snarest *el.* Lånet bør fornyes snarest.

Bemærk at det er valgfrit om man vil indskyde ‑e- eller ej i disse ord,
og at det altså altid er korrekt at lade være med at indskyde ‑e- i
verber der i infinitiv ender på en trykstærk vokal.

##### (c) Ordene *vi(e)* og *gi(e)*

To verber der i infinitiv kan udtales i én eller to stavelse(r), kan
skrives enten med eller uden ‑e: gi eller gie (hale sejl op) og vi eller
vie.

#### (2) Præteritum

I verber der i præteritum bøjes som ri, bo osv., skrives
præteritumendelsen ‑ede, altså riede, boede, syede osv. Præteritum af
verbet dø skrives døde.

Verber som i præteritum ender på trykstærk vokal, får tilføjet ‑s
direkte til den trykstærke vokal: Kysten sås tydeligt.

### § 30. Imperativ

#### (1) Hovedregel

Man danner imperativ af verber der i infinitiv ender på tryksvagt -e,
ved at fjerne e'et:

> Skriv snart igen!

> Hils fra mig!

> Indsend bestillingskuponen i dag!

Dog må en imperativ som hovedregel ikke ende på to ens konsonanter (jf.
§ 8.2):

> Tilsæt en teskefuld salt.

> Kom snart hjem!

Verber hvortil der svarer et substantiv med dobbelt slutkonsonant,
skrives dog også med dobbelt konsonant i imperativ, fx Grill selv din
bøf, Stress lidt af i ferien.

Verber der i infinitiv ender på en trykstærk vokal eller på konsonanten
-s, er uændrede i imperativ:

> Tø ærterne op før brug.

> Sy selv dit tøj!

> Tilse ventilen regelmæssigt!

> Slås ikke så meget!

> Kløjes nu ikke i maden.

#### (2) Usædvanlige bogstavforbindelser

Nogle imperativer kommer til at ende på konsonantforbindelser som ellers
ikke forekommer sidst i et ord:

> Åbn døren!

> Pensl brødet med sammenpisket æg.

> Klistr derefter hurtigt de frie ender sammen.

> Sagtn farten!

> Behandl pakken varsomt!

Sådanne skrivemåder kan dog virke afstikkende og kan ofte erstattes af
andre formuleringer, fx

> Luk døren op!

> Brødet pensles med sammenpisket æg.

> Klæb derefter hurtigt de frie ender sammen.

> Sæt farten ned!

> Pakken bør behandles varsomt.

Om imperativer der ender på trykstærkt ‑er, se § 5.4.

#### (3) Ord fra engelsk

Hovedreglen for dannelsen af imperativ af verber fra engelsk er den
samme som for alle andre verber, dvs. at man fjerner infinitivendelsen
-e og den ene af to ens konsonanter, fx brows, coach, drop, host, kidnap
og leas (til browse, coache, droppe, hoste, kidnappe og lease). Om
imperativ af ord som grille og stresse, se § 30.1.

Der er imidlertid en række undtagelser hvor verber fra engelsk har samme
form i imperativ som i infinitiv, fx delete, fade, franchise, outsource,
shine, spice og tape.

Der kan ikke gives udtømmende regler for hvordan man danner imperativ af
engelske lån. Det tilrådes derfor at man i tvivlstilfælde søger
oplysninger under de enkelte ord i selve ordbogen.

§ 31-35. Præteritum participium
-------------------------------

### § 31. Præteritum participiums bøjningsformer

Præteritum participium har bøjningsformer der betegner bestemthed, tal
og køn:

#### (1) Bestemt form og pluralis

Den bestemte form er lig med pluralisformen. I nogle svagtbøjede verber
er endelsen ‑ede, i andre ‑te:

> den lejede bil

> det kendte ansigt

> de vaskede duge

> nogle udvalgte deltagere.

I nogle stærktbøjede verber er endelsen ‑ne, i andre ‑ede og i atter
andre ‑te:

> nogle for længst afhjulpne mangler

> den beskrevne fremgangsmåde

> i det givne øjeblik

> den opslåede stilling

> fastslåede kendsgerninger

> den afbrudte forestilling

> det udeladte afsnit

> et par slidte sko.

I flere tilfælde kan endelsen valgfrit være ‑ede eller ‑ne, fx den
bedragede *el.* bedragne hustru, de genopdragede *el.* genopdragne børn.
Det gælder de verber der i opslagsdelen har begge disse former angivet
som pluralis af deres participier, fx

be\|dra\|ge vb., -r, bedragede el. bedrog, bedraget (foran fælleskønsord
også bedragen), bedragne el. bedragede (jf. § 31-34); en bedragen el.
bedraget ægtefælle; et bedraget folk; bedragne el. bedragede vælgere\
\
be\|drog vb., præt. af bedrage

#### (2) Kønsbøjning i ubestemt form singularis

Kønsbøjning af præteritum participium kan forekomme i den ubestemte
singularisform af de participier som i bestemt form og pluralis kan have
endelsen ‑ne. Der kan skelnes mellem en intetkønsform (ubøjet form) med
endelsen ‑et og en fælleskønsform med endelsen ‑en:

> fundet -- funden

> strøget -- strøgen

> udkommet -- udkommen.

### § 32. Præteritum participium foran substantiv

Præteritum participium kan stå attributivt, dvs. umiddelbart foran et
substantiv som participiet er knyttet til. Bøjningen i bestemthed, tal
og køn fremgår i princippet af § 31.

Når det gælder kønsbøjningen (§ 31.2), ligger sprogbrugen dog ikke fast,
men i mange tilfælde er det almindeligt at bruge intetkønsformen, også
når participiet er knyttet til et substantiv af fælleskøn. I sådanne
tilfælde kan det virke mere formelt (eller gammeldags) at bruge
fælleskønsformen:

> en indskrevet *el.* indskreven elev

> en afsvedet *el.* afsveden skovstrækning

> en strøget *el.* strøgen skjorte

> en aftvunget *el.* aftvungen tilståelse

> en stærkt beskåret *el.* beskåren pengebeholdning

> en nylig udkommet *el.* udkommen bog

> en indløbet *el.* indløben ordre

> en stjålet *el.* stjålen cykel

> en udeblevet *el.* udebleven menstruation

> en forsvundet *el.* forsvunden ubåd.

### § 33. Præteritum participium efter hjælpeverber mv.

#### (1) Efter *have* og *få*

Efter hjælpeverberne have og få bruges præteritum participium i ubøjet
form (ubestemt singularis intetkøn):

> Vi har lejet en bil til turen.

> Spejderne fik solgt alle lodsedlerne.

> Hun skal nok snart få brugt pengene.

> Hvor har du fundet de sager?

> Jeg har fået stjålet min cykel.

#### (2) Efter *være* og *blive*

Efter hjælpeverberne være og blive bruges præteritum participium i nogle
tilfælde i ubøjet form, i andre tilfælde i bøjet form:

##### (a) Handlingsforløb

Når der fortrinsvis tænkes på et handlingsforløb, bruges ubøjet form:

> Hele tre biler blev lejet til turen.

> Alle lodsedler blev solgt af spejderne.

> Pengene vil nok snart blive brugt.

> Er de sager stadig ikke blevet fundet?

> Min cykel er blevet stjålet.

> De blev overrasket af uvejret.

> Er kagerne spist eller smidt ud?

> Billetterne til i morgen er allerede afbestilt.

##### (b) Tilstand

Når der fortrinsvis tænkes på en tilstand (jf. også § 34), kan
participiet behandles som et adjektiv og bøjes (jf. § 35). Det gælder
især når participiet er gradsbestemt:

> Hans sko er meget slidte.

> Vi blev ret overraskede da vi hørte fra ham.

> Medarbejderne er særdeles motiverede.

Men i mange tilfælde er ubøjet form almindelig sprogbrug uanset om der
er tale om en handling eller en tilstand:

> Alle tre biler er lejet *(el. *lejede*)*.

> Begge deres børn er adopteret *(el. *adopterede*)*.

> Tallene i eksemplet er reguleret *(el. *regulerede*)*.

> Nødderne er hakket *(el. *hakkede*)*.

> Tusindvis af boliger er misligholdt *(el. *misligholdte*)*.

Ubøjet form er helt almindelig når præteritum participium indgår i en
fast forbindelse med en efterfølgende præposition, fx irriteret over,
beregnet til, indstillet på:

> Vi var irriteret *(el. *irriterede*)* over at høre på hendes
> beklagelser.

> Beslagene er beregnet *(el. *beregnede*)* til udendørs brug.

> Ministrene synes at være indstillet *(el. *indstillede*)* på at
> forfølge sagen.

> Vi ser os nødsaget *(el. *nødsagede*)* til at aflyse.

#### (3) Efter andre verber

Også i andre tilfælde hvor præteritum participium hører nøje sammen med
sætningens verbal, bruges normalt ubøjet form:

> Rapporterne forlanges indleveret senest onsdag.

> Cyklerne bedes henstillet i stativerne.

> Ejendomsmægleren venter begge huse solgt i morgen.

> Det gælder om at få pengene brugt i en fart.

> Kunden ønsker møblerne ombetrukket.

> Jeg har fået min cykel stjålet.

> Man har hørt alle ansøgerne beskrevet som uduelige.

### § 34. Præteritum participium som frit prædikativ

Når præteritum participium står som frit prædikativ
(tilstandsbetegnelse), er det i mange tilfælde almindeligt at bruge den
ubøjede form. I nogle tilfælde bruges dog normalt den bøjede form:

> Alle kom opløftet *el.* opløftede tilbage fra kurset.

> Papirerne sendes underskrevet *el.* underskrevne til virksomheden
> inden 14 dage.

> Forskrækket *el.* forskrækkede ved lyden af toget løb børnene væk fra
> skinnerne.

> Hjemkommet *el.* hjemkommen fra ferie tog hun igen fat på arbejdet.

> Vi kom trætte og gennemblødte hjem.

> Vrede og oprørte gik de deres vej.

### § 35. Adjektiver dannet af præteritum participium

#### (1) Bøjningsformer

Mange adjektiver består helt eller delvis af oprindelige præteritum
participier, fx kneben, løssluppen, nystrøgen *el.* nystrøget,
glatbarberet, ulakeret, velvalgt, henrykt. Sådanne participier har i
princippet samme bøjningsformer som andre adjektiver der ender på ‑en,
‑et eller ‑t. Adjektiver der ender eller kan ende på ‑en, følger dog
forskellige mønstre. En del tilføjer ‑t i intetkøn og kommer altså til
at ende på ‑ent, fx kneben (et knebent flertal). Nogle har i intetkøn
valgfrihed mellem en form på ‑ent og en form på ‑et, fx fremskreden (et
fremskredent el. fremskredet tidspunkt), og enkelte kan kun ende på ‑et,
fx gudgiven (et gudgivet svar). De fleste af de adjektiver på ‑en der
har en valgfri form på ‑et, fx nystrøgen *el.* nystrøget, ubeskreven
*el.* ubeskrevet, kan i intetkøn kun ende på ‑et: et nystrøget forklæde,
et ubeskrevet blad. De nøjagtige bøjningsoplysninger må søges under de
enkelte ord i selve ordbogen.

Adjektiver der er dannet af præteritum participium, og som ender eller
kan ende på ‑en, er opført i Retskrivningsordbogen som selvstændige
opslagsord (fx kneben, løssluppen, nystrøgen *el.* nystrøget). Af de ord
der ender på ‑et eller ‑t, er nogle opført som selvstændige opslagsord
(fx henrykt, interesseret, ubemærket, velplejet), mens andre ikke er med
i ordbogen (fx nyvasket, ulakeret).

Enkelte af de adjektiver der ender på ‑en eller ‑et, kan i bestemt form
og i pluralis bøjes på to måder, fx

> den optagede *el.* optagne telefon

> de ubeskårede *el.* ubeskårne indtægter.

Oplysninger om sådanne bøjningsmuligheder er anført under det enkelte
ord i Retskrivningsordbogen.

#### (2) Brug af bøjningsformerne

Bøjningsformer af adjektiver dannet af præteritum participium bruges
principielt på samme måde som bøjningsformerne af andre adjektiver:

> en kneben sejr

> et knebent flertal

> nogle knebne sejre

> en nystrøgen *el.* nystrøget skjorte

> de nystrøgne *el.* nystrøgede gardiner

> et hengivent menneske

> Reolerne er ulakerede.

> Kartoflerne må være ganske nyopgravede.

> Kasserollerne hang blankpolerede på messingstangen.

> Lavt monterede fortasker giver bedst balance på cyklen.

> Hun grinede svedent.

Når sådanne adjektiver indgår i en fast forbindelse med en efterfølgende
præposition, er det dog helt almindeligt at bruge ubøjet form:

> Vi er helt uinteresseret *(el. *uinteresserede*)* i den slags.

> De var henrykt *(el. *henrykte*)* over forslaget.

§ 36-39. Adverbier og adverbialer
---------------------------------

### § 36. Rene adverbier og *t*-adverbialer

#### (1) Rene adverbier

Rene adverbier er ord der kun kan bruges som adverbier, fx

> aldeles, aldrig, endnu, gerne, navnlig, naturligvis, nemlig, ofte,
> sandelig, sandsynligvis, sædvanligvis, temmelig, vistnok.

Næsten alle rene adverbier er uden ‑t:

> Det var en temmelig enkel sag.

> Det har jeg vistnok hørt om før.

> Han interesserer sig navnlig for russisk.

> Hun får sandsynligvis ingen praktikplads i år.

Ved enkelte rene adverbier er der dog valgfrihed mellem en form med ‑t
og en form uden ‑t, fx grangivelig *el.* grangiveligt, morderlig *el.*
morderligt og sødelig *el.* sødeligt. De rene adverbier er i selve
ordbogen opført som selvstændige opslagsord med ordklasseangivelsen adv.
(adverbium)/bio. (biord):

san\|de\|lig adv.sø\|de\|lig (el. sødeligt) adv.; sove sødelig\
\
sø\|de\|ligt (el. sødelig) adv.; sove sødeligt

#### (2) *T*-adverbialer (adverbialer dannet af adjektiver)

T-adverbialer er adverbialer der er dannet af adjektiver. Det er
hovedreglen at sådanne adverbialer ender på ‑t hvis adjektivet kan have
denne endelse:

> Du må ikke råbe så højt.

> Krisen var hurtigt forbi.

> Klaveret er grusomt falsk.

> Det drejer sig om en relativt stor mængde.

> De fik monteret en automatisk [(jf. §
> 26)]{style="font-weight: normal; font-style: normal;"} virkende
> dørlukker.

> Det arbejde er for ringe udført.

Sådanne adverbialer er ikke opført som selvstændige opslagsord i
Retskrivningsordbogen. De falder sammen med adjektivets intetkønsform og
må derfor søges under de pågældende adjektiver, fx

høj adj., -t, -eau\|to\|ma\|tisk adj., itk. d.s., -e

Om adverbialer dannet af adjektiver på ‑ig og ‑lig, se § 38, og om
adverbialer dannet af adjektiver på ‑vis, se § 39.

### § 37. Betydningsforskel mellem *t*-adverbialer og rene adverbier

Ved visse ord er der en betydningsforskel mellem et t-adverbial med ‑t
og det tilsvarende rene adverbium uden ‑t, fx mellem t-adverbialet
lovligt og det rene adverbium lovlig, mellem endeligt og endelig, knapt
og knap, ligefremt og ligefrem, nært og nær. Her betegner t-adverbialet
den måde noget forholder sig på eller foregår på, mens det rene
adverbium som hovedregel angiver afsenderens holdning til eller
vurdering af det der siges (fx om det er sikkert eller usikkert, ventet
eller uventet, ønskeligt eller ikke ønskeligt):

> Det var en lovligt [(på en lovlig måde,
> legalt)]{style="font-weight: normal; font-style: normal;"} varslet
> konflikt.

> Det var en lovlig [(lidt
> for)]{style="font-weight: normal; font-style: normal;"} stor mundfuld.

> Han talte ligefremt [(på en ligefrem måde, direkte,
> enkelt)]{style="font-weight: normal; font-style: normal;"}.

> Han har ligefrem [(overraskende nok,
> endog)]{style="font-weight: normal; font-style: normal;"} penge med
> til os.

> De afgjorde sagen endeligt
> [(definitivt)]{style="font-weight: normal; font-style: normal;"}.

> Jeg har endelig [(langt om
> længe)]{style="font-weight: normal; font-style: normal;"} fundet frem
> til nummeret.

> De var nært
> [(inderligt)]{style="font-weight: normal; font-style: normal;"}
> knyttet til deres far.

> Han havde nær
> [(næsten)]{style="font-weight: normal; font-style: normal;"} mistet
> sin stilling.

> Der blev uddelt knapt
> [(sparsommeligt)]{style="font-weight: normal; font-style: normal;"}
> afmålte rationer.

> Man forstår knap [(næsten
> ikke)]{style="font-weight: normal; font-style: normal;"} hvad han
> mener.

> Han arbejdede præcist [(med
> præcision)]{style="font-weight: normal; font-style: normal;"}.

> Jeg forstår præcis
> [(fuldstændig)]{style="font-weight: normal; font-style: normal;"} hvad
> du mener.

> Toget kører præcis [(på
> slaget)]{style="font-weight: normal; font-style: normal;"} kl. 12.

Sådanne t-adverbialer er ikke opført som selvstændige opslagsord i selve
ordbogen. De falder sammen med adjektivets intetkønsform og må derfor
søges under det pågældende adjektiv. De rene adverbier er derimod opført
som selvstændige opslagsord. Til illustration af betydningsforskellen
mellem t-adverbialet og det tilsvarende rene adverbium er der ved
opslagsordene anført betydningsforklaringer og/eller eksempler, fx

lov\|lig adj., -t, -e (i overensstemmelse med loven; retmæssig); være
lovligt undskyldtlov\|lig adv. (lidt for); lovlig fræk; lovlig meget

### § 38. Adverbialer dannet af adjektiver på -*ig* eller -*lig*

#### (1) Mådesadverbialer

Adverbialer der er dannet af adjektiver på ‑ig eller ‑lig, følger
hovedreglen (jf. § 37) og tilføjes ‑t når de betegner den måde noget
forholder sig på eller foregår på:

> Lyset bevægede sig uregelmæssigt [(på en uregelmæssig
> måde)]{style="font-weight: normal; font-style: normal;"}.

> Frugttræerne skal beskæres omhyggeligt [(på en omhyggelig
> måde)]{style="font-weight: normal; font-style: normal;"}.

> Jeg har aldrig set et så omhyggeligt beskåret frugttræ.

> Han kan ikke skrive rigtigt.

> Hun smilede venligt.

> Billedet forestillede en venligt smilende person.

> Du må prøve at tale tydeligt.

> De spiller forfærdeligt.

> Hun rejste sig roligt op.

> Han spiller faktisk dårligt.

> Katten strakte sig mageligt i solen.

> Han udtrykte sig meget personligt.

> Jeg gjorde udtrykkeligt opmærksom på risikoen ved boliglånet.

> De fortryder det bitterligt.

#### (2) Tidsadverbialer

Adverbialer som betegner tid, og som er dannet af adjektiver på ‑ig
eller ‑lig, følger hovedreglen (jf. § 37) og tilføjes ‑t:

> Hvor meget tjener du årligt?

> Det er en månedligt tilbagevendende begivenhed.

> Togkørslen er midlertidigt indstillet.

> De besøger os jævnligt.

> Børnene vågnede tidligt om morgenen.

Ved ordene bestandig, evig, foreløbig, idelig, nylig, samtidig og
sluttelig er ‑t dog valgfrit:

> Kampen var tabt for bestandig *el.* bestandigt.

> De kommer evig *el.* evigt og altid for sent.

> Vi bliver foreløbig *el.* foreløbigt boende.

> Han taler idelig *el.* ideligt om sit nye hus.

> De er nylig *el.* nyligt blevet skilt.

> De to tog afgår samtidig *el.* samtidigt.

> Sluttelig *el.* slutteligt vil jeg sige jer en stor tak.

#### (3) Gradsadverbialer

Et gradsadverbial der er dannet af et adjektiv på ‑ig eller ‑lig, følger
hovedreglen (jf. § 37) og tilføjes ‑t når det står som selvstændigt
sætningsled:

> Han glædede sig afsindigt til jubilæet.

> Deres løn er steget væsentligt det sidste år.

> Filmen kedede mig gudsjammerligt.

> Fodbold interesserer mig ikke særligt.

> Alle morede sig vældigt ved festen.

> Jeg elsker dem inderligt.

> Vores konkurrenceevne bliver styrket væsentligt.

Hvis gradsadverbialet derimod lægger sig til et adjektiv eller et ord
anvendt som et adjektiv, er det valgfrit om ‑t tilføjes:

> Der var afsindig *el.* afsindigt mange mennesker i lokalet.

> Deres lønstigning var væsentlig *el.* væsentligt større end forventet.

> Filmen var gudsjammerlig *el.* gudsjammerligt kedelig.

> Jeg er ikke særlig *el.* særligt interesseret i fodbold.

> Vi vil vældig *el.* vældigt gerne med til festen.

> Han er mig inderlig *el.* inderligt ligegyldig.

> Vores konkurrenceevne bliver væsentlig *el.* væsentligt styrket.

Ord med en sådan mulighed for valgfrit ‑t er i Retskrivningsordbogen
opført således:

væ\|sent\|lig adj., -t, -e, som adv. også uden -t, fx en væsentligt el.
væsentlig forbedret udgave (jf. § 38)

Også andre adverbialer dannet af adjektiver på ‑ig eller ‑lig kan dog --
mere eller mindre lejlighedsvis -- bruges som gradsadverbialer og kan
tilsvarende undvære ‑t i en sådan anvendelse, fx en uforklarlig ringe
indsats.

#### (4) Andre adverbialer

Valgfrihed mellem en form med ‑t og en form uden ‑t forekommer også ved
andre adverbialer dannet af adjektiver på ‑ig eller ‑lig. Det gælder
først og fremmest adverbialer der betegner sted, samt de adverbialer der
betegner afsenderens holdning til eller vurdering af det der siges (jf.
§ 37):

> Vinduerne skal males udvendig *el.* udvendigt.

> Kyllingen skal gnides indvendig *el.* indvendigt med salt.

> Personlig *el.* personligt er jeg ikke i tvivl.

> Vi kan dårlig *el.* dårligt løse problemet for dig.

> De klarer antagelig *el.* antageligt ikke prøven.

Når sådanne adverbialer har valgfrit ‑t, er de opført i selve ordbogen
på følgende måde:

ind\|ven\|dig adj., -t, -e, som adv. også uden -t, fx ovnen skal
rengøres indvendigt el. indvendig (jf. § 38)

### § 39. Adverbialer dannet af adjektiver på -*vis*

Ved adverbialer der er dannet af adjektiver på ‑vis, er der valgfrihed
mellem en form med ‑t og en form uden ‑t:

> Tropperne trak sig etapevis *el.* etapevist tilbage.

> Udbetalingerne finder sted månedsvis *el.* månedsvist.

> De besøgte os kun lejlighedsvis *el.* lejlighedsvist.

> Skulpturen bestod af lagvis *el.* lagvist anbragte skiver.

> Deres synspunkter har ændret sig gradvis *el.* gradvist.

> De var kun delvis *el.* delvist uenige.

En undtagelse fra ovenstående er adjektivet næsvis, som har ‑t når det
bruges som adverbial:

> De svarede næsvist igen.

Adverbialer der er dannet af adjektiver på ‑vis, er ikke opført som
selvstændige opslagsord i selve ordbogen. De falder sammen med
adjektivets intetkønsform og må derfor søges under det pågældende
adjektiv, fx

grad\|vis adj., gradvist el. gradvis, -e

Rene adverbier der ender på ‑vis (fx naturligvis), får aldrig tilføjet
‑t (jf. § 36.1). -- Om adjektiver der ender på ‑vis, se § 27.

§ 40-60. Tegnsætning {#tegnsætning xmlns="http://www.w3.org/1999/xhtml" h="http://www.w3.org/1999/xhtml"}
====================

### § 40. Indledning

Tegnsætning skal lette forståelsen af skrevne tekster. De enkelte tegn
(punktum, semikolon, komma, spørgsmålstegn osv., jf. § 2.1) bruges som
hovedregel til at sammenbinde eller adskille helheder i teksten og har
ofte en funktion der svarer til fx rytme, tempo og pauser i det talte
sprog.

De forskellige tegn kan præge en skreven tekst i forskellig grad. En
tekst med mange udråbstegn eller prikker eller tankestreger kan let
komme til at virke påfaldende på læseren.

Reglerne for de forskellige tegn er heller ikke af samme art. Ved nogle
tegn -- fx ved komma og spørgsmålstegn -- er der tale om faste regler
for hvornår man skal sætte tegn, og hvornår man ikke skal. Ved andre
tegn -- fx ved udråbstegn og tankestreg -- er der tale om regler som
giver en udstrakt grad af valgfrihed, og som i højere grad har karakter
af tilbud end af påbud.

§ 41-43. Punktum
----------------

### § 41. Slutpunktum

#### (1) Mellem sætninger og inde i sætninger

Punktum kan bruges til at afgrænse og afslutte selvstændige eller
forholdsvis selvstændige dele af en tekst, først og fremmest
helsætninger (med eller uden ledsætninger):

> Jeg tager som regel med bussen.

> Tilsæt en teskefuld salt.

> Stik mig lige skruetrækkeren.

> Han vidste ikke om dækslet var skruet på.

> Ole havde meldt afbud på grund af forkølelse. Men Lars var der som
> sædvanlig.

> Overfor en vulkan har man ingen chancer. Det er så store energimængder
> der slippes løs ved et vulkanudbrud, at de ikke på nogen måde kan
> tæmmes. Vand duer ikke. Den vulkan der for år tilbage dannede
> vulkanøen Surtsey syd for Island, startede på havbunden. Og den blev
> ved med at sprutte, uanset hvor meget vand der var over krateret.

Punktum kan afgrænse og afslutte andet end sætninger. Det kan fx være
forkortede sætninger:

> I morgen rejser vi. Klokken halv syv.

> Har du ikke set Lise? Jo, for en halv time siden.

> Der var mange besøgende. Også svenskere.

> Torsdag. Er stadig meget træt. Stod sent op. Henrik ringede ved
> middagstid.

Punktum kan med en særlig virkning bruges til at fremhæve en
uselvstændig sætning eller en del af en sætning:

> Til den eftertragtede stilling valgte man en ung ingeniør. Som
> arbejdede for den lokale partileder.

> Jeg fik skam også et skriftligt svar. 4 måneder senere.

Om forholdet mellem punktum og semikolon, se § 44.

#### (2) Udeladelse af punktum

Der sættes normalt ikke punktum efter sætninger, forkortede sætninger
eller ord som står alene i en linje, idet linjebruddet fungerer som
tegn. Der sættes således ikke punktum i følgende tilfælde:

##### (a) Overskrifter

Eksempler:

> Storm i Vestjylland

> Det er ganske vist

> Jeg vidste intet om bedragerierne, siger tidligere direktør

Der skal dog sættes punktum (eller kolon, jf. § 11.3.b) inde i
overskrifter hvis denne består af flere selvstændige dele:

> Ret og rimelighed. 40 år i retssikkerhedens tjeneste

##### (b) Adresser

Eksempel:

> Dansk Sprognævn

> Adelgade 119 B

> 5400 Bogense

##### (c) Datoangivelser over eller under skrivelser

Eksempel:

> Næstved(,) 23. marts 2024

##### (d) Indledningshilsner i mails, breve og andre skrivelser

Eksempel:

> Kære Bente Carlsen

> Hej Camilla

Om brug af udråbstegn i sådanne tilfælde, se § 54.2.

Om komma ved udråb, se § 47.3.b.

##### (e) Slutformler og underskrifter i mails, breve og andre skrivelser

Eksempel:

> Med venlig hilsen

> Anders H. Hansen

### § 42. Forkortelsespunktum

Denne paragraf indeholder hovedreglerne for hvordan man bruger
forkortelsespunktum, men giver i øvrigt ikke udtømmende regler for
brugen af dette tegn. -- Hvad angår brugen af punktum i bestemte
forkortelser, kan det tilrådes at søge oplysninger under den enkelte
forkortelse i selve ordbogen.

#### (1) Forkortelser i skrift og tale

##### (a) Forkortelser kun i skrift

Forkortelsespunktum viser at et ord i den skriftlige form er afkortet
ved at bogstaver er udeladt:

> ca., f.eks. *(men *fx [uden
> punktum]{style="font-weight: normal; font-style: normal;"}*)*, gns.
> *el.* gnsn., Chr. Winther, Kbh., hhv., mfl. *el.* m.fl., bl.a., hr.,
> kr., jnr. *el.* j.nr.

Metersystemets (og visse andre enheders) forkortelser er dog uden
forkortelsespunktum:

> cm, m, m², km, g, kg, dl, l *el.* L, kHz, dB, V, A, W

Der sættes heller ikke forkortelsespunktum efter betegnelser på
postdistrikter: Odense C, København NV mv. Det samme gælder forkortelser
for landsdele i postadresser: Nykøbing Sj, Viby J mv.

##### (b) Forkortelser i både skrift og udtale

Når et ord eller en ordforbindelse er forkortet i både skrift og udtale,
bruges der normalt ikke forkortelsespunktum:

> SAS, USA, PH [(forfatteren Poul
> Henningsen)]{style="font-weight: normal; font-style: normal;"}, TV
> *el.* tv, IT *el.* it, MF *el.* mf

Der sættes dog forkortelsespunktum i delvis forkortede navne:

> Peter P. Rohde, Storm P., H.C. Andersen, Th. Lang, J.-J. Rousseau,
> J.Th. Lundbye

og i akademiske titler:

> stud.polyt., cand.mag., ph.d., dr.med.vet.

#### (2) Forkortede ordforbindelser

I visse forkortede ordforbindelser kan der sættes forkortelsespunktum
efter hele ordforbindelsen eller efter hver ordforkortelse, fx

> mfl. *el.* m.fl.

> mht. *el.* m.h.t.

> mv\. *el.* m.v.

> pga. *el.* på gr. af

> th. *el.* t.h.

> tv. *el.* t.v.

#### (3) Ordenstal

Forkortelsespunktum sættes efter tal for at vise at de er ordenstal:

> Frederik 10., Margrethe 2., den 11. september 2001, 11.9.2001, 2.
> verdenskrig.

Romertal brugt som ordenstal står dog uden forkortelsespunktum:

> Christian IV

> Frederik X

#### (4) Forkortelsespunktum som sluttegn

Når et ord med forkortelsespunktum står sidst i en sætning, sættes der
kun ét punktum:

> Opgiv venligst dit personnummer, og indsend rejsebilag og lign.

Andre tegn end punktum sættes altid:

> Kan du ikke lige sende en mail med oplysninger om adresse,
> telefonnummer osv.?

#### (5) Mellemrum

Der skrives ikke mellemrum mellem de enkelte dele af en forkortelse:

> osv., m.m., bl.a., A.D. *(*anno Domini*)*, H.C. Andersen.

Før og efter uforkortede ord laves sædvanligt ordmellemrum:

> a c. [(dvs.]{style="font-weight: normal; font-style: normal;"} a
> conto[)]{style="font-weight: normal; font-style: normal;"}, og lign.,
> på gr. af, A. Olsen.

### § 43. Prikker

#### (1) Udeladelsesprikker

Med dobbelt eller tredobbelt punktum (to eller tre prikker) efter
hinanden kan man vise at ord eller orddele er udeladt.

Bemærk at der ved udeladte ord sættes mellemrum mellem
udeladelsesprikker og omkringliggende ord:

> Det fremgik af sagen at klagerens ægtefælle \... afgik ved døden den
> 5. august 1995, og at den af ham drevne cykelforretning \... blev
> afhændet ca. 14 dage før dødsfaldet.

> Sigtede .. fremstilles i grundlovsforhør i morgen kl. 10.

Ved udeladte orddele sættes der ikke mellemrum mellem
udeladelsesprikkerne og resten af ordet. Der sættes heller ikke
mellemrum mellem udeladelsesprikkerne og et evt. følgende sluttegn:

> Hvad h\... er egentlig meningen?

> F.. det!

> Det var lige godt f.., sagde han.

#### (2) Tøveprikker

I personlig eller litterær stil kan man med to eller flere punktummer
(tøveprikker) antyde noget uafsluttet eller tøvende.

Bemærk at der sættes mellemrum mellem tøveprikker og omkringliggende
ord:

> -- Hvis jeg ellers kan hjælpe \... med noget \...

> -- Ellers tak \... Jeg giver dem bare hvad jeg har \... lidt ærter og
> skinke \...

> Han tændte alarmen, og så skete det hele igen ..

> Du kunne jo også .. gøre noget andet?

> Hun lytter til stilheden \.... og hører noget i den \.... noget som
> vækker minder om det der var engang.

Hvis tøveprikkerne efterfølges af et sluttegn, sættes der ikke mellemrum
mellem tøveprikkerne og sluttegnet:

> Først var det kedeligt, men så \...!

> Var det nu også det hun sagde ..?

### § 44. Semikolon

#### (1) Mellem helsætninger

Semikolon kan, ligesom punktum, bruges til at afgrænse forholdsvis
selvstændige dele af teksten, først og fremmest helsætninger (jf. §
41.1). Men samtidig forbinder semikolon to helsætninger og viser at de
hører særlig tæt sammen mht. indhold:

> Ole kunne ikke komme; han var forkølet. Men Lars var der som
> sædvanlig.

> Arbejdet begynder på torsdag. Alle bedes møde præcis kl. 7.00; ellers
> kan vi ikke komme i gang.

> Plankeværket var blæst omkuld; men det var kun hvad man kunne vente.
> Det var værre at det nye tag var beskadiget.

#### (2) Punktum og semikolon

Specielt kan man ved hjælp af semikolon i længere tekststykker vise
hvilke dele de falder i. Punktum afgrænser hovedafsnittene, semikolon
forbinder underafsnittene:

> Indlandsisen på Grønland vejer så meget at det svarer til at der på
> hver kvadratmeter af den isdækkede del hviler en vægt der i gennemsnit
> er på 1350 tons; det er nok til at tynge landet ned. Grønland har på
> en måde form som en stor skål med høje bjerge rundt langs kysten og et
> lavland i midten. Nu for tiden ligger lavlandet lidt under havets
> overflade; så hvis man tænkte sig indlandsisen fjernet, ville de lave
> områder blive oversvømmet af havet. I løbet af et par tusind år ville
> der imidlertid ske en landhævning så det indre af Grønland blev
> tørlagt. Samtidig ville bjergene langs kysten blive lidt lavere; for
> jordskorpen er presset sammen så der er en fordybning under isen og en
> lav vold eller rand udenom.

#### (3) Opremsning

Tilsvarende kan man ved hjælp af semikolon inddele en opremsning i
grupper:

> Forsikringen omfatter skader på: antikviteter, malerier,
> kunsthåndværk, ægte tæpper; ure, kameraer og projektører med tilbehør,
> kikkerter; pelsværk, skind.

> Patientens temperatur blev i døgnets løb målt til 39,7; 38,1; 37,7;
> 36,9.

§ 45-51. Komma
--------------

### § 45. Indledende bemærkninger

Denne og de følgende paragraffer (§ 45-51) indeholder reglerne for
kommatering. Reglerne er med enkelte undtagelser identiske med reglerne
for traditionelt grammatisk komma. Den afgørende undtagelse er at det
som hovedregel er valgfrit om man vil sætte startkomma, dvs. komma før
ledsætninger (se § 49-50). Uanset om man vælger at sætte startkomma
eller ej, skal man følge samme praksis indenfor samme tekst.

### § 46. Opremsningskomma mv.

#### (1) Generelt

Der sættes komma (opremsningskomma) mellem sideordnede led som ikke er
forbundet med konjunktion. I praksis vil det sige at der sættes komma
hvor der kunne have stået et og, et men eller et eller:

> Han købte kartofler, gulerødder og blomkål. *(Men: *Han købte
> kartofler og gulerødder og blomkål*)*.

> Fyrretræ er både smukt, holdbart og ret billigt.

> Skabet er dels for stort, dels for dyrt.

> Han var snart højt oppe, snart igen langt nede.

> Jorden er nogle steder for tør, andre steder for fugtig.

> På én måde var det godt, på en anden måde skidt.

> Det var i Hvidovre, ikke i Vanløse.

> Nok se, ikke røre!

> Jeg skal enten til Paris, London eller Berlin.

> Der kommer nogen, men jeg ved ikke hvem, hvorfor og hvornår.

Om komma ved sideordnede helsætninger og ledsætninger, se § 48 og §
49.2.

#### (2) Sideordnede adjektiver

Der sættes komma mellem to sideordnede adjektiver som ikke er forbundet
med konjunktion:

> en lille, idyllisk by [(dvs. en by der er lille og
> idyllisk)]{style="font-weight: normal; font-style: normal;"}

> en kold, frostklar vinterdag [(dvs. en vinterdag der er kold og
> frostklar)]{style="font-weight: normal; font-style: normal;"}

> et stort, sort uhyre [(dvs. et uhyre der er stort og
> sort)]{style="font-weight: normal; font-style: normal;"}.

Hvis det første adjektiv derimod er underordnet en helhed der består af
det andet adjektiv og det efterfølgende substantiv, sættes der ikke
komma mellem de to adjektiver:

> en lille fransk by [(dvs. en fransk by der er
> lille)]{style="font-weight: normal; font-style: normal;"}

> en iskold lys pilsner [(dvs. en lys pilsner der er
> iskold)]{style="font-weight: normal; font-style: normal;"}

> en arrig ruhåret foxterrier [(dvs. en ruhåret foxterrier der er
> arrig)]{style="font-weight: normal; font-style: normal;"}.

#### (3) Stillingsbetegnelser og titler

Mellem stillingsbetegnelser, titler, akademiske grader o.l. der ikke er
forbundet med og, sættes der komma:

> chefredaktør, administrerende direktør Hanne Nielsen

> formand for bestyrelsen, lektor, ph.d. Peter Knudsen

> direktør, cand.polit. Lars P. Jensen

> professor, dr.phil. Bente Carlsen

Der sættes ikke komma mellem ordene hr., fr., frk., fru og en
stillingsbetegnelse og normalt heller ikke mellem et navn og en
efterstillet grad:

> hr. direktør, cand.polit. Lars P. Jensen HD

#### (4) Adresser o.l.

Der sættes normalt komma mellem de enkelte dele af adresser og lignende
beskrivelser når de skrives ud i ét:

> Dansk Sprognævn, Adelgade 119 B, 5400 Bogense

> T. Nielsen, Nørregade 65 B, 2. th.

> Jens Hansen, Slagelse

> Arbejds- og Miljømedicinsk Afdeling, Bispebjerg Hospital

> 12 brædder, 420 cm, trykimprægnerede

> »Oprør fra Midten«, Gyldendal, 1977, side 54

> varemærkeloven, § 11, stk. 1 *(men: *varemærkelovens § 11, stk. 1*)*

> fredag den 23. marts 2024(,) kl. 16.00

> Kolding(,) (den) 23. marts 2024.

I løbende tekst sættes der desuden komma efter sidste del af
beskrivelsen, fx

> I varemærkeloven, § 11, stk. 1, kan man finde nærmere oplysninger.

> Kontakt T. Nielsen, Nørregade 65 B, 2. th., snarest muligt.

Anvisningerne i dette punkt udelukker ikke at man i særlige faglige
sammenhænge, fx i litteraturlister, registre o.l., vælger at bruge en
anden tegnsætning mellem de enkelte dele af beskrivelsen.

#### (5) Forstærkende gentagelse

Der sættes komma foran forstærkende gentagelser som de følgende:

> Jeg blev meget, meget glad for hans brev.

> Det var en lang, lang rejse.

### § 47. Komma ved selvstændige sætningsdele

#### (1) Generelt

Med komma afgrænser man ord eller sætningsdele der står med en vis
selvstændighed, ofte ligesom udenfor sætningen. Selvstændige
sætningsdele er kendetegnet ved at de i reglen kan udelades uden at
sammenhængen bliver meningsløs. Komma fungerer her som et
fremhævelsesmiddel på linje med parentes og tankestreg og afgrænser hvad
der i talt sprog ofte markeres ved hjælp af rytme, tonegang, pauser,
tempo og lignende lydlige signaler:

> Man kan, muligvis, finde en anden forklaring
> [(=]{style="font-weight: normal; font-style: normal;"} Man kan
> (muligvis) finde en anden
> forklaring[)]{style="font-weight: normal; font-style: normal;"}.

> Jeg er ikke spor træt, endnu
> [(=]{style="font-weight: normal; font-style: normal;"} Jeg er ikke
> spor træt --
> endnu[)]{style="font-weight: normal; font-style: normal;"}.

> Hun er 22 år, og enke

> Soldaterne havde, trætte og svedige efter den lange marchtur, lagt sig
> i grøften.

Når ord og sætningsdele som de nævnte står som almindelige,
ikkefremhævede led, sættes der derimod ikke noget komma, fx

> Man kan muligvis finde en forklaring.

> Jeg er ikke spor træt endnu.

> Hun er 22 år og enke.

> Soldaterne havde trætte og svedige efter den lange marchtur lagt sig i
> grøften.

Det er ofte en skønssag om en sætningsdel står med en sådan grad af
selvstændighed at den bør afgrænses med komma. Specielt ved
konstruktioner med participium kan man være i tvivl. I sådanne tilfælde
er der som hovedregel ikke grund til at sætte komma:

> Man interesserede sig især for skader forårsaget af gammastråler.

> Et galæble er en misdannelse fremkaldt af galhvepse.

Men i nogle tilfælde, specielt ved relativt lange eller tunge led, kan
der dog sættes komma, fx

> Et galæble er en kugleformet misdannelse på undersiden af egeblade(,)
> fremkaldt af galhvepse.

> Man sigter mod en stabil aftale(,) garanteret af stormagterne og med
> tilslutning fra alle medlemslande.

> Prisen er på kun en måned steget med 30 %(,) svarende til den normale
> prisstigning for et helt år.

#### (2) Apposition

Der sættes komma omkring appositioner:

> Den største danske å, Gudenåen, løber gennem Silkeborg.

> Fenol, den dødsensfarlige gift, anvendes fortsat i industrien.

> Jeppe Aakjær, jyden, og Thorkild Gravlund, sjællænderen, har begge
> digtet om deres hjemstavn.

> De brugte deres sædvanlige taktik, at trække angriberne offside.

> To unge mænd, sønner af den afdøde, stod i baggrunden.

> Ansøgninger om støtte sendes til selskabets formand, Julie
> Frederiksen.

Derimod sættes der ikke komma omkring ikkeparentetiske udtryk som de
følgende:

> Den store danske å Gudenåen løber gennem Silkeborg.

> Den dødsensfarlige gift fenol anvendes fortsat i industrien.

> Jyden Jeppe Aakjær og sjællænderen Thorkild Gravlund har begge digtet
> om deres hjemstavn.

> Aftenens foredragsholder er ekstern lektor ved Syddansk Universitet
> Jeppe Carlsen.

#### (3) Led udenfor sætningen

Der sættes komma ved led der står udenfor sætningen: (a) tiltaleord, (b)
udråb, (c) spørgende tilføjelser, (d) frie prædikativer der er
slutstillede, og (e) visse andre led i ekstraposition:

##### (a) Tiltaleord

> Kom herhen, Hans!

> Kammerater, nu er tiden inde!

##### (b) Udråb

> Øv, nu gik den i stykker!

> Kan du da ikke høre efter, for pokker!

> Tak, det var en stor hjælp.

> Så, nu punkterede jeg igen.

> Ja, nu kommer vi.

> Ja ja, så siger vi det.

> Hej, du der. Kom lige herhen!

> Men Frederik, det kan vi da ikke gøre.

> Nej, selvfølgelig ikke, Ida.

> Højlydt sagde hun: »Hejsa, Peter!«

> »Hej, Jørgen,« mumlede han da han gik forbi.

Se også § 41.2.d og § 54.2 om indledningshilsner i mails, breve og andre
skrivelser.

##### (c) Spørgende tilføjelser

> Du er medlem af klubben, ikke?

> Han protesterer da ikke, vel?

> Hun er nok kommet i godt selskab, hvad?

##### (d) Frie prædikativer der er slutstillede

> Skytten går ud, tavs og ene.

> Endelig nåede vi hjem med hele flokken, glade over at være sluppet for
> uheld undervejs.

##### (e) Ekstraposition

> Peter, ham kan vi vel stole på?

> Den lille butik på hjørnet, det er min onkels.

> Var han ikke nordmand, ham Holberg?

> På fredag, da skal jeg til tandlæge.

> I Grønland, der kan det faktisk blive ret varmt om sommeren.

> I morgen, så gør jeg det.

#### (4) Forklaringer og præciseringer

Der sættes komma ved forklarende og præciserende tilføjelser. Det gælder
også når disse tilføjelser indeholder ledsætninger:

> De kom for sent, bl.a. på grund af den uregelmæssige togdrift.

> De kom for sent, bl.a. fordi togdriften var uregelmæssig.

> Nu og da går de helt amok, fx i eksamenstiden.

> Nu og da går de helt amok, fx når eksamen nærmer sig.

> Konferencen gennemføres kun med tilstrækkelig mange tilmeldte, dvs.
> mindst 65.

> Konferencen gennemføres kun med tilstrækkelig mange tilmeldte, dvs.
> forudsat der melder sig mindst 65.

> Vi skal være klar til afgang kl. 4, uanset vejret.

> Vi skal være klar til afgang kl. 4, uanset om det regner eller ej.

> Vi skal, uanset om det regner eller ej, være klar til afgang kl. 4.

> Turen må aflyses, dels på grund af vejret, dels på grund af mangel på
> tid.

> Turen bliver gennemført, også i regnvejr.

> Til dette formål distingverer, skelner, man mellem to former for
> adfærd.

> Et par mindre bygninger, nemlig laboratoriet og kontoret, nedbrændte.

> De håndterede køkkengrejet, herunder vaffeljernet, som om de aldrig
> havde bestilt andet.

> De er altid ude, enten til møder eller demonstrationer.

> Vi skal nok nå det, måske allerede i næste uge.

#### (5) Parentetiske relativsætninger og andre selvstændige ledsætninger

Der sættes komma omkring selvstændige ledsætninger, herunder
ledsætninger som har karakter af forklarende og præciserende
tilføjelser. Det gælder dels (a) parentetiske relativsætninger, dels (b)
andre selvstændige ledsætninger:

##### (a) Parentetiske relativsætninger

Parentetiske relativsætninger kan i reglen kendes på at de ikke er
nødvendige for identifikationen af det led som de henviser til, og at de
derfor normalt kan udelades uden at sammenhængen bliver meningsløs. De
ville derfor ofte lige så godt kunne stå i parentes eller mellem
tankestreger eller være formuleret som selvstændige helsætninger:

> Forleden spurgte min makker, der ellers ikke interesserer sig for
> fugle, om jeg ikke syntes svalerne fløj lavt. *(= *Forleden spurgte
> min makker (der ellers ikke interesserer sig for fugle) om jeg ikke
> syntes svalerne fløj lavt*)*.

> Filmen er instrueret af Sofia Coppola, som er datter af Francis Ford
> Coppola. *(= * Filmen er instrueret af Sofia Coppola. Hun er datter af
> Francis Ford Coppola*)*.

> Jeg kender tilfældigvis hendes første mand, som bor et sted i
> provinsen. *(= *Jeg kender tilfældigvis hendes første mand. Han bor et
> sted i provinsen*)*.

> Vi kan ikke godtage denne undskyldning, som vi i øvrigt har hørt mange
> gange før. *(= *Vi kan ikke anerkende denne undskyldning -- som vi i
> øvrigt har hørt mange gange før*)*.

> Dette emne, som mange kender til, men som kun få vil tale om, er et af
> vor tids mest påtrængende spørgsmål. *(= *Dette emne -- som mange
> kender til, men som kun få vil tale om -- er et af vor tids mest
> påtrængende spørgsmål*)*.

> I øvrigt er princippet det samme, hvad der også fremgår af
> beskrivelsen ovenfor. *(= *I øvrigt er princippet det samme; det
> fremgår også af beskrivelsen ovenfor*)*.

> Der er indgået en ny aftale på området, hvorfor de hidtidige satser
> ikke længere gælder. *(= *Der er indgået en ny aftale på området.
> Derfor gælder de hidtidige satser ikke længere*)*.

##### (b) Andre selvstændige ledsætninger

Også andre ledsætninger end parentetiske relativsætninger kan stå med en
sådan selvstændighed at de skal afgrænses med komma:

> Han optrådte roligt og fattet, omend han ikke var helt upåvirket af
> situationens alvor.

> Jeg bliver hurtigt træt, hvorimod hun kan blive ved i timevis.

> Jeg bliver hurtigt træt, mens hun kan blive ved i timevis.

> Man bør tale tydeligt, således at der ikke opstår tvivl.

Om komma ved ledsætninger i øvrigt, se § 49-50.

#### (6) Komma foran *men*

Der sættes altid komma foran men når det forbinder to helsætninger (jf.
§ 48.1), og der kan desuden valgfrit sættes komma foran et men der ikke
forbinder to sætninger:

> Vi ser ikke fjernsyn(,) men læser avis.

> Hotellet var billigt(,) men til gengæld også elendigt.

> Endelig kom de tilbage, trætte(,) men lykkelige.

Undertiden står et led der indledes med men, med en særlig grad af
selvstændighed eller fremhævelse. I sådanne tilfælde sættes der komma
både før og efter men-leddet (jf. § 47.1):

> Trætte, men lykkelige, kom de tilbage. *(= *Trætte -- men lykkelige --
> kom de tilbage*)*.

Om komma ved sætninger forbundet med men, se § 48 og § 49.2.

### § 48. Helsætninger

Det er normalt punktum der bruges til at adskille helsætninger, men ofte
hører to eller flere helsætninger så tæt sammen at det er tilstrækkeligt
at adskille dem med komma:

#### (1) Mellem helsætninger der er forbundet med konjunktion

Der sættes komma mellem helsætninger der er forbundet med en af
konjunktionerne og, eller, men, for, thi eller så:

> Vinden peb, og tordenen rullede.

> Lene tog mig på ordet og ankom dagen efter, og hun så ud til at
> befinde sig udmærket.

> Hun var højt kvalificeret, og da vi i forvejen har for få kvindelige
> kranførere, gav vi hende jobbet.

> Enten er han syg, eller også er han bortrejst.

> Du skal skynde dig, men du kan godt låne min cykel.

> Der er flere muligheder, men har du ikke vinterdæk, må du hellere køre
> denne vej.

> Her er hundekoldt, for vinduet har stået åbent.

> Det kan være farligt, for når der er pålandsvind, slår bølgerne op
> over molen.

> Selv dansede præsten ikke, thi det var ikke helt passende.

> Jeg havde glemt min nøgle, så jeg kunne ikke komme ind.

> Der er næsten overtegnet, så hvis du vil med, må du melde dig til med
> det samme.

At der i disse tilfælde er sat komma, udelukker ikke at der i andre
tilfælde kan sættes et andet tegn, fx punktum eller semikolon, foran
konjunktioner som og og men.

#### (2) Ved opremsning

Der sættes komma (opremsningskomma, se § 46) mellem sideordnede
helsætninger som ikke er forbundet med konjunktion. I praksis vil det
sige at der sættes komma mellem helsætninger hvor der kunne have stået
et og, et eller eller et men:

> Regnen piskede, vinden peb, og tordenen rullede.

> Snart måtte vi vade gennem bække, snart måtte vi springe over kløfter.

> Dels er vejret for dårligt, dels har vi ikke tid.

> Er han syg, er han bortrejst, eller har han bare glemt det?

> Nogle fik is, andre foretrak pølser.

> I dag har vi fri, i morgen har vi kun tre timer.

> Den ene halvdel af klassen har idræt, den anden halvdel har håndværk
> og design.

#### (3) Ved gentagelse af verbal og subjekt

Der sættes komma mellem en helsætning og en efterfølgende sætning der
gentager den første sætnings subjekt og verbal:

> Han er god nok, er han.

> Vi må se at få lidt fart på, vi må.

> Der var ikke meget ved den film, var der vel?

Der sættes også komma i tilfælde hvor verbalet repræsenteres af en form
af gøre:

> Han kommer alligevel ikke, gør han?

#### (4) Ved imperativer

Sætninger med imperativ kan betragtes som helsætninger med »indbygget«
subjekt, og der sættes derfor typisk komma ved imperativer på samme måde
som ved andre helsætninger:

> Spis noget mindre, og dyrk også noget motion.

> Spis noget mindre, eller løb et par kilometer tre gange om ugen.

> Hent lige kosten, og tænd under kartoflerne.

> Tag det lidt med ro, og det hele går meget lettere.

> Rør jævnligt i gryden, men gør det med let hånd.

> Spis noget mindre, drik postevand, og dyrk noget motion.

Men tit er to imperativer meget tæt forbundet. I sådanne tilfælde er det
normalt valgfrit om man vil sætte komma eller ej:

> Hent lige kosten(,) og fej gulvet

> Følg mit eksempel(,) og dyrk lidt motion

> Spis, drik(,) og vær glad.

I nogle tilfælde hører imperativerne dog så tæt sammen at komma bør
udelades:

> Rend og hop!

> Skold og smut mandlerne.

> Skynd dig hjem og hent den.

> Kom og se min nye tilbygning.

> Tag og køb en dusk persille med til sovsen.

> Stå ikke dér og se så fortvivlet ud!

> Vind eller forsvind.

#### (5) Ved anførende udtryk (inkvit)

Der sættes komma ved anførende udtryk (inkvit) der står til slut (eller
inde i) en replik, et citat e.l.:

> -- Det er din egen skyld, bemærkede hun og gik sin vej.

> »Tiden er inde,« sagde han, »til at skifte signaler.«

> Tillykke med fødselsdagen, råbte de.

> Rødvin i moderate mængder er godt for hjertet, viser en ny engelsk
> undersøgelse.

Når replikken, citatet e.l. slutter med et spørgsmålstegn eller
udråbstegn, kan kommaet dog udelades.

Om rækkefølgen af komma og anførselstegn, se § 59.4.

#### (6) Ved ufuldstændige helsætninger

Ved helsætninger hvor verbalet er udeladt, sættes der komma som ved
fuldstændige helsætninger:

> Han gik til højre, og jeg til venstre.

> Kornet stod gult, havren grøn.

> Frederik lovede at komme, og Knud også.

> Han ud af stuen, og jeg efter ham.

> Du må komme, og det straks.

Ved helsætninger hvor subjektet er udeladt, sættes der ikke komma hvis
sætningerne er forbundet med konjunktion:

> Hun tog mig på ordet og ankom dagen efter.

Hvis helsætninger hvor subjektet er udeladt, ikke er forbundet med
konjunktion, sættes der komma som ved fuldstændige helsætninger:

> Han bukker, takker og går ud igen.

Om komma ved opremsning af helsætninger, se § 48.2.

§ 49-50. Ledsætninger
---------------------

Med komma kan man afgrænse ledsætninger. Det sker dels ved hjælp af
kommaer efter ledsætninger, de såkaldte *slutkommaer*, dels ved hjælp af
kommaer før ledsætninger, de såkaldte *startkommaer*. Der skal normalt
altid sættes *slutkommaer* ved en ledsætning, hvorimod det som
hovedregel er valgfrit om man vil sætte *startkommaer* eller ej. Uanset
om man vælger at sætte startkomma eller ej, skal man følge samme praksis
indenfor samme tekst.

Her i ordbogen er der ikke sat startkomma ved ledsætninger. Der er dog
sat startkomma i de eksempler i § 49-50 der skal vise brugen af
startkomma.

### § 49. Komma eller ikke komma

#### (1) Hovedregel: fast slutkomma, valgfrit startkomma

Der skal normalt altid sættes slutkomma efter en ledsætning (se dog §
49.2.b og § 49.6 nedenfor), hvorimod det som hovedregel er valgfrit om
man også vil sætte startkomma foran ledsætningen (se dog § 47.5 ovenfor
og § 49.3 nedenfor). Eksemplerne i det følgende viser kommateringen ved
ledsætninger afhængigt af om man har valgt at sætte startkomma (venstre
spalte), eller om man har valgt at udelade startkommaet (højre spalte).

Eksemplerne er opdelt i grupper. Gruppe (a) indeholder eksempler hvor
der kun er mulighed for at sætte slutkomma, og kommateringen er derfor
den samme uanset om man i øvrigt har valgt at sætte startkomma eller ej.
Gruppe (b) indeholder eksempler hvor der kun er mulighed for at sætte
startkomma, og kommateringen er derfor forskellig alt efter om man har
valgt at sætte startkomma eller ej. Det samme gælder gruppe (c), der
indeholder eksempler hvor der er mulighed for både at sætte slutkomma og
startkomma, og gruppe (d), der indeholder eksempler med flere
ledsætninger i samme helsætning.

##### (a) Eksempler der kun har mulighed for slutkomma:

> Når svalerne flyver lavt, bliver det regnvejr.

> Mens vi stod og så ud over Islands Brygge, fortalte min makker om sine
> sommerferieplaner.

> At svalerne flyver lavt, er nu ikke noget sikkert tegn på regn.

> Selvom vi havde sovet længe, var ilden ikke gået ud.

> Hvis nogen af beboerne har betalt for meget i acontovarme, får de
> pengene tilbage til den første.

> Hvorfor hun er forsinket, ved vi ikke.

> Hvilke oplysninger der er nødvendige, afhænger af det pågældende lands
> lovgivning.

> Hvem der havde sat ild til bygningen, kunne politiet ikke finde ud af.

##### (b) Eksempler der kun har mulighed for startkomma:

  Startkomma valgt til                                                                                      Startkomma valgt fra
  --------------------------------------------------------------------------------------------------------- --------------------------------------------------------------------------------------------------------
  *Vi forventer, at det bliver regnvejr.*                                                                   *Vi forventer at det bliver regnvejr.*
  *Det er nu ikke noget sikkert tegn på regn, at svalerne flyver lavt.*                                     *Det er nu ikke noget sikkert tegn på regn at svalerne flyver lavt.*
  *Jeg gik, for at hun kunne være alene.*                                                                   *Jeg gik for at hun kunne være alene.*
  *Du skal teste apparatet grundigt for at sikre dig, at det virker.*                                       *Du skal teste apparatet grundigt for at sikre dig at det virker.*
  *Han var nervøs for, at hun skulle føle sig alene.*                                                       *Han var nervøs for at hun skulle føle sig alene.*
  *Jeg gik, fordi hun havde bedt om at være alene.*                                                         *Jeg gik fordi hun havde bedt om at være alene.*
  *Det blæser, så (at) hele huset ryster.*                                                                  *Det blæser så (at) hele huset ryster.*
  *Spis, så længe du er sulten.*                                                                            *Spis så længe du er sulten.*
  *Det er længe siden, svalerne har fløjet så lavt.*                                                        *Det er længe siden svalerne har fløjet så lavt.*
  *Man siger, at det bliver regnvejr, når svalerne flyver lavt.*                                            *Man siger at det bliver regnvejr når svalerne flyver lavt.*
  *Pokkers også, at svalerne flyver så lavt!*                                                               *Pokkers også at svalerne flyver så lavt!*
  *Manden, der ville være en østers [(filmtitel)]{style="font-weight: normal; font-style: normal;"}*        *Manden der ville være en østers [(filmtitel)]{style="font-weight: normal; font-style: normal;"}*
  *Der er for længst blevet udsendt en opgørelse til de beboere, som har betalt for meget i acontovarme.*   *Der er for længst blevet udsendt en opgørelse til de beboere som har betalt for meget i acontovarme.*
  *Ske, hvad der vil.*                                                                                      *Ske hvad der vil.*
  *Godt, du kom.*                                                                                           *Godt du kom.*
  *Ring, hvis det bliver regnvejr.*                                                                         *Ring hvis det bliver regnvejr.*
  *Tag bare et æble, eller hvad du vil have.*                                                               *Tag bare et æble eller hvad du vil have.*
  *Tro, hvad du vil.*                                                                                       *Tro hvad du vil.*
  *De fløj, som om der var optræk til regn.*                                                                *De fløj som om der var optræk til regn.*
  *Han har ingen idé om, hvor mange af dem der vil med.*                                                    *Han har ingen idé om hvor mange af dem der vil med.*
  *Vi ved ikke, hvilke af de nye elever der kommer i elevrådet.*                                            *Vi ved ikke hvilke af de nye elever der kommer i elevrådet.*

##### (c) Eksempler der har mulighed for både slutkomma og startkomma:

  Startkomma valgt til                                                                                                                                   Startkomma valgt fra
  ------------------------------------------------------------------------------------------------------------------------------------------------------ ---------------------------------------------------------------------------------------------------------------------------------------------------
  *Jeg lagde straks mærke til, at svalerne fløj lavt, og hentede derfor min paraply.*                                                                    *Jeg lagde straks mærke til at svalerne fløj lavt, og hentede derfor min paraply.*
  *Skønt man siger, det bliver regnvejr, når svalerne flyver lavt, vil jeg nu løbe an på, at det bliver tørvejr hele dagen, og at stævnet kan holdes.*   *Skønt man siger det bliver regnvejr når svalerne flyver lavt, vil jeg nu løbe an på at det bliver tørvejr hele dagen, og at stævnet kan holdes.*
  *Når bygningen forlades efter kl. 18 (eller på tidspunkter, hvor kontoret er lukket), skal porten låses.*                                              *Når bygningen forlades efter kl. 18 (eller på tidspunkter hvor kontoret er lukket), skal porten låses.*
  *Den, der sover, synder ikke.*                                                                                                                         *Den der sover, synder ikke.*
  *For at sikre dig, at apparatet virker, skal du teste det grundigt.*                                                                                   *For at sikre dig at apparatet virker, skal du teste det grundigt.*
  *Det hold, som jeg arbejder på, starter kl. 23.30.*                                                                                                    *Det hold som jeg arbejder på, starter kl. 23.30.*
  *Det hold, jeg arbejder på, starter kl. 23.30.*                                                                                                        *Det hold jeg arbejder på, starter kl. 23.30.*
  *Vi havde hans bemærkninger om, at så små kommuner ikke bør drive biblioteker, i tankerne, da vi indbød ham til at deltage i debatten.*                *Vi havde hans bemærkninger om at så små kommuner ikke bør drive biblioteker, i tankerne da vi indbød ham til at deltage i debatten.*
  *Vi gør alt, hvad vi kan, for at rette op på skaderne.*                                                                                                *Vi gør alt hvad vi kan, for at rette op på skaderne.*

##### (d) Ledsætninger der er led i andre ledsætninger

Bemærk at der, hvis man vælger at sætte startkomma, skal sættes komma
foran alle ledsætninger indenfor samme helsætning, altså også foran
ledsætninger der er led i andre ledsætninger (se eksempler i venstre
spalte nedenfor). Og bemærk tilsvarende at der, hvis man vælger ikke at
sætte startkomma, først skal sættes slutkomma når ledsætningen er helt
slut, dvs. at man ved ledsætninger der er led i andre ledsætninger,
først skal sætte komma (eller et andet sluttegn) efter den sidste af
ledsætningerne (se eksempler i højre spalte nedenfor):

  Startkomma valgt til                                                                                                         Startkomma valgt fra
  ---------------------------------------------------------------------------------------------------------------------------- -------------------------------------------------------------------------------------------------------------------------
  *Man siger, at det bliver regnvejr, når svalerne flyver lavt.*                                                               *Man siger at det bliver regnvejr når svalerne flyver lavt.*
  *Skønt man siger, det bliver regnvejr, når svalerne flyver lavt, vil jeg nu løbe an på, at det bliver tørvejr hele dagen.*   *Skønt man siger det bliver regnvejr når svalerne flyver lavt, vil jeg nu løbe an på at det bliver tørvejr hele dagen.*
  *At det bliver regnvejr, når svalerne flyver lavt, er en gammel erfaring.*                                                   *At det bliver regnvejr når svalerne flyver lavt, er en gammel erfaring.*
  *Vi havde godt hørt, at han er svær at samarbejde med, når han ikke får sin vilje.*                                          *Vi havde godt hørt at han er svær at samarbejde med når han ikke får sin vilje.*

Ledsætninger kan dog godt stå ved siden af hinanden uden at den sidste
ledsætning er led i den første, og i så fald sættes slutkommaet regelret
dér hvor den første ledsætning slutter, fx

  Startkomma valgt til                                                                                                                                       Startkomma valgt fra
  ---------------------------------------------------------------------------------------------------------------------------------------------------------- ---------------------------------------------------------------------------------------------------------------------------------------------------------
  *Vi havde godt hørt, at han er svær at samarbejde med, da vi opstillede ham til bestyrelsen.*                                                              *Vi havde godt hørt at han er svær at samarbejde med, da vi opstillede ham til bestyrelsen.*
  *Ombudsmanden kan ikke behandle klager over forhold, der kan indbringes for en højere forvaltningsmyndighed, før denne myndighed har truffet afgørelse.*   *Ombudsmanden kan ikke behandle klager over forhold der kan indbringes for en højere forvaltningsmyndighed, før denne myndighed har truffet afgørelse.*

Se også § 49.2 om komma mellem sideordnede ledsætninger og § 50.6 om
startkommaets placering ved ledsætninger med hv-ord, som om og fordi.

#### (2) Mellem sideordnede ledsætninger

##### (a) Der sættes komma mellem sideordnede ledsætninger:

> At flyet landede planmæssigt, og at hun nåede rettidigt frem til
> mødet, var simpelthen et lykketræf.

> Hvis publikum svigter, eller hvis der igen kommer prisforhøjelser, får
> vi underskud.

> Når alle melder sig, og når ingen svigter, skal det nok gå.

> Når stormen suser, når regnen styrter ned, og når tordenen brager, er
> det nu rart at have tag over hovedet.

Kommaet mellem sideordnede ledsætninger sættes uanset om man i øvrigt
har valgt at sætte eller at udelade startkomma:

  Startkomma valgt til                                                      Startkomma valgt fra
  ------------------------------------------------------------------------- ------------------------------------------------------------------------
  *Han sagde, at han meldte afbud, og at han ville sende en begrundelse.*   *Han sagde at han meldte afbud, og at han ville sende en begrundelse.*
  *Planten trives bedst, hvor jorden er sumpet, og hvor der er skygge.*     *Planten trives bedst hvor jorden er sumpet, og hvor der er skygge.*
  *Det er et emne, som mange kender til, men som kun få vil tale om.*       *Det er et emne som mange kender til, men som kun få vil tale om.*

##### (b) Sideordnede ledsætninger med fælles indledningsord

Kommaet mellem sideordnede ledsætninger kan dog valgfrit udelades når
ledsætningerne har fælles indledningsord, dvs. når
underordningskonjunktionen er udeladt i den anden (eller en senere)
ledsætning. Denne valgfrihed gælder uanset om man i øvrigt har valgt at
sætte eller at udelade startkomma:

  Startkomma valgt til                                                               Startkomma valgt fra
  ---------------------------------------------------------------------------------- ---------------------------------------------------------------------------------
  *Planten trives bedst, hvor jorden er sumpet(,) og der er skygge.*                 *Planten trives bedst hvor jorden er sumpet(,) og der er skygge.*
  *Vi får underskud, hvis publikum svigter(,) og der igen kommer prisforhøjelser.*   *Vi får underskud hvis publikum svigter(,) og der igen kommer prisforhøjelser.*
  *Når alle melder sig(,) og ingen svigter, skal det nok gå.*                        *Når alle melder sig(,) og ingen svigter, skal det nok gå.*

Kommaet mellem sideordnede ledsætninger kan også udelades når
indledningsordet (at eller som) mangler i både den første og den anden
ledsætning:

  Startkomma valgt til                                            Startkomma valgt fra
  --------------------------------------------------------------- --------------------------------------------------------------
  *Jeg tror, Olsen bliver forfremmet(,) og Jensen rejser.*        *Jeg tror Olsen bliver forfremmet(,) og Jensen rejser.*
  *Det er et emne, mange kender til(,) men kun få vil tale om.*   *Det er et emne mange kender til(,) men kun få vil tale om.*

#### (3) Fast startkomma ved selvstændige ledsætninger

Der sættes altid startkomma ved selvstændige ledsætninger, herunder
parentetiske relativsætninger, fx

> Han optrådte roligt og fattet, omend han ikke var helt upåvirket af
> situationens alvor.

> Jeg bliver hurtigt træt, hvorimod hun kan blive ved i timevis.

> Vi kan ikke anerkende denne undskyldning, som vi i øvrigt har hørt
> mange gange før.

Kommaet ved selvstændige ledsætninger sættes uanset om man i øvrigt har
valgt at sætte eller at udelade startkomma. Se nærmere i § 47.5, der
også giver flere eksempler på ledsætninger med fast startkomma.

#### (4) Ikke komma mellem konjunktion og ledsætning

Der sættes ikke komma mellem konjunktioner som og, men, eller, for, thi,
så, at, til og en efterfølgende ledsætning:

> Hun var højt kvalificeret, og da vi i forvejen har for få kvindelige
> kranførere, gav vi hende jobbet.

> Der er flere muligheder, men har De ikke vinterdæk, må De hellere køre
> denne vej.

> Det kan være farligt, for når der er pålandsvind, slår bølgerne op
> over molen.

> Der er næsten overtegnet, så hvis du vil med, må du melde dig til med
> det samme.

> Vi må gemme resten, til hvis vi virkelig kommer i knibe.

Kommaet mellem konjunktion og ledsætning udelades uanset om man i øvrigt
har valgt at sætte eller at udelade startkomma:

  Startkomma valgt til                                                 Startkomma valgt fra
  -------------------------------------------------------------------- -------------------------------------------------------------------
  *Han har lovet, at når han kommer til byen, så vil han besøge os.*   *Han har lovet at når han kommer til byen, så vil han besøge os.*
  *Jeg forstår, at uanset hvad resultatet bliver, så vil hun klage.*   *Jeg forstår at uanset hvad resultatet bliver, så vil hun klage.*

Se også § 50.2 om startkommaets placering ved forbindelser med som og
end.

#### (5) Valgfrit startkomma i sætningsknude

I en sætningsknude kan startkommaet altid udelades foran den eller de
ledsætninger hvorfra et led er flyttet frem. Hvis man i øvrigt har valgt
at sætte startkomma ved ledsætninger, kan man dog også valgfrit sætte
startkomma i sætningsknuder (se eksempler i venstre spalte). Men hvis
man ellers ikke sætter startkomma ved ledsætninger, skal der heller ikke
sættes startkomma ved sætningsknuder (se eksempler i højre spalte).

  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
  Startkomma valgt til                                                                      Startkomma valgt fra
  ----------------------------------------------------------------------------------------- -------------------------------------------------------------------------------------
  *Det ved han(,) at vi gør.\                                                               *Det ved han at vi gør.*
  *(Men: *Han ved, at vi gør det*)*.*                                                       

  *Det tror jeg(,) at han ved(,) at vi gør.\                                                *Det tror jeg at han ved at vi gør.*
  *(Men: *Jeg tror, at han ved, at vi gør det*)*.*                                          

  *Det synes Anders selv(,) er ret smart.*                                                  *Det synes Anders selv er ret smart.*

  *De sko synes jeg(,) er ret flotte.*                                                      *De sko synes jeg er ret flotte.*

  *Hvem synes I(,) vi skal invitere?*                                                       *Hvem synes I vi skal invitere?*

  *At det er upraktisk, mente jeg(,) vi allerede var blevet enige om.*                      *At det er upraktisk, mente jeg vi allerede var blevet enige om.*

  *Her er der vist ikke mange(,) der bryder sig om at bo, når først vinteren sætter ind.*   *Her er der vist ikke mange der bryder sig om at bo når først vinteren sætter ind.*

  *I har slet ikke fortalt, hvem I synes(,) vi skal invitere.*                              *I har slet ikke fortalt hvem I synes vi skal invitere.*

  *Vi har truffet en afgørelse, (som) jeg ikke venter(,) han bliver glad for.*              *Vi har truffet en afgørelse (som) jeg ikke venter han bliver glad for.*

  *Bogen har nogle mangler, (som) man må håbe(,) er rettet i kommende udgaver.*             *Bogen har nogle mangler (som) man må håbe er rettet i kommende udgaver.*
  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#### (6) Valgfrit komma ved ufuldstændige ledsætninger o.l.

##### (a) Efter ufuldstændige ledsætninger o.l.

Efter ufuldstændige ledsætninger hvor verbalet er udeladt, og efter
faste udtryk der kan opfattes som ledsætninger (eller ufuldstændige
ledsætninger), kan der valgfrit sættes slutkomma, fx

> Hvis hun får lov, kommer hun. Hvis ikke(,) ved vi nu grunden.

> Skønt syg og nervesvækket(,) deltog han i mødet.

> Hvornår(,) kan ingen få opklaret.

> For så vidt angår § 22(,) har jeg ingen indvendinger.

> Som tidligere nævnt(,) var situationen kritisk.

> Han interesserede sig kun for skader forårsaget af gammastråling(,) og
> afviste helt at beskæftige sig med andet.

Det anbefales dog at være tilbageholdende med at sætte komma i sådanne
tilfælde.

##### (b) Foran ufuldstændige ledsætninger o.l.

Foran ufuldstændige ledsætninger og visse faste ledsætningslignende
udtryk sættes der normalt ikke startkomma uanset om man i øvrigt har
valgt at sætte eller at udelade startkomma ved ledsætninger:

  Startkomma valgt til                                           Startkomma valgt fra
  -------------------------------------------------------------- -------------------------------------------------------------
  *Vi aftalte, at han skulle gå til højre og jeg til venstre.*   *Vi aftalte at han skulle gå til højre og jeg til venstre.*
  *Man siger jo, at tiderne ændres og vi med dem.*               *Man siger jo at tiderne ændres og vi med dem.*
  *Der er ingen, der er mere ked af det end Ole.*                *Der er ingen der er mere ked af det end Ole.*
  *Der kommer gæster, men vi ved ikke hvor mange.*               *Der kommer gæster, men vi ved ikke hvor mange.*
  *Jeg har lige så god kondi som du.*                            *Jeg har lige så god kondi som du.*
  *Ordlyden er som følger.*                                      *Ordlyden er som følger.*

Sådanne udtryk kan undertiden stå med en vis selvstændighed og kan af
den grund afgrænses med komma uanset om man i øvrigt har valgt at sætte
eller at udelade startkomma (jf. § 47).

### § 50. Startkommaets placering

Som det er fremgået af eksemplerne i § 49, placeres startkommaet som
hovedregel umiddelbart før den ledsætning kommaet afgrænser. I nogle
tilfælde hører et ord eller en ordforbindelse i den overordnede sætning
dog så nøje sammen med ledsætningen at startkommaet i stedet skal eller
kan placeres foran dette led og altså ikke kommer til at stå lige foran
ledsætningen. Startkommaet kan således komme til at stå (1) foran en
præposition, (2) foran en af sammenligningskonjunktionerne som og end
eller (3) foran et adverbial, herunder specielt (4) foran et
tidsadverbial der efterfølges af en tidsledsætning med udeladt
konjunktion.

Bemærk at reglerne her i § 50 om kommaets placering kun er relevante
hvis man har valgt generelt at sætte startkomma foran ledsætninger. Hvis
man har valgt at undlade at sætte startkomma, sættes der som hovedregel
slet ikke komma ved de problematiske forbindelser med præpositioner,
konjunktioner og adverbialer (jf. dog § 51 om muligheden for at sætte et
komma for at tydeliggøre meningen eller undgå misforståelse).

#### (1) Foran præposition

Når en præposition eller et ord eller en ordforbindelse der bruges som
præposition, hører nøje sammen med en efterfølgende ledsætning, sættes
kommaet foran præpositionen:

> Han blev meget ivrig, efter at du var gået. *(Men: *Han blev meget
> ivrig efter, at du skulle gå*)*.

> Kortet åbnes, ved at man afriver randen. *(Men: *Han er ikke tryg ved,
> at de beholder hans pas*)*.

> Man kan få rabat, mod at man betaler forud. *(Men: *De har ingenting
> imod, at man betaler forud*)*.

> De trængte ind, uden at nogen mærkede det.

> Du kan sidde her, forudsat at du ikke blander dig.

> Vi har ingen kommentarer, udover hvad der fremgår af brevet.

> Vi vil gerne se dig, i anledning af at vores datter skal døbes.

> Vi kommer kl. 12 eller 13, afhængigt af om vi når færgen eller ej.

Der sættes således heller ikke startkomma mellem præposition og
konjunktion i tilfælde som de følgende, hvor ledsætningen står forrest i
helsætningen:

> Uanset hvad der sker, skal vi være klar kl. 4.

> Efter at du var gået, blev han meget ivrig.

> I betragtning af at han var så træt, gik det meget godt.

#### (2) Foran *som* og *end*

Der sættes ikke komma mellem sammenligningskonjunktionerne som og end og
en umiddelbart efterfølgende ledsætning, men startkommaet sættes i
stedet foran sammenligningskonjunktionen:

> Det er nu ikke nær så sjovt, som da Lassen var leder.

> Man hører snart aldrig andet, end at tiderne er dårlige.

> Det er ikke andet, end hvad man kunne vente.

I tilfælde hvor ledsætningen ikke følger umiddelbart efter
sammenligningskonjunktionen, sættes kommaet foran ledsætningen:

> Det er nu ikke nær så sjovt som dengang, da Lassen var leder.

> Man hører snart aldrig andet end den klagesang, at tiderne er dårlige.

> Har vi ikke andre kartofler end dem, der ligger i køleskabet?

> Vores nye hus er ikke nær så stort som det, vi boede i før.

#### (3) Foran adverbial

Når et adverbial eller et ord eller en ordforbindelse der bruges som
adverbial, hører nøje sammen med en efterfølgende ledsætning, sættes
startkommaet foran adverbialet:

> Han hvilede sig, lidt inden gæsterne kom. *(Men med anden
> betydning: *Han hvilede sig lidt, inden gæsterne kom*)*.

> Jeg ringede, lige mens de holdt møde. *(Men: *Jeg ringer lige, mens de
> holder møde*)*.

> Bøgerne blev nedsat, en måned efter at vi havde betalt fuld pris for
> dem.

> Hun kom, netop som jeg stod og trak uret op.

> Han græder, næsten hver gang man kritiserer ham. *(Men med anden
> betydning: *Han græder næsten, hver gang man kritiserer ham*)*.

> Toget standsede, et øjeblik før det nåede Roskilde. *(Men med anden
> betydning: *Toget standsede et øjeblik, før det nåede Roskilde*)*.

> Man bør tale tydeligt, således at der ikke opstår tvivl. *(Men: *Man
> bør tale således, at der ikke opstår tvivl*)*.

> Vi fordrev tiden, så godt (som) vi nu kunne.

> Denne funktion kan tilsluttes, indtil 30 minutter efter at tændingen
> er afbrudt.

> Du må komme, lige meget hvad der sker.

> Vi har frist til 1. august, dvs. at der er masser af tid.

> Nu og da går de helt amok, især når de ikke kan finde deres nøgler.

> Vi får sandsynligvis regn, bl.a. fordi svalerne flyver så lavt.

> Vi hepper altid på vores kammerater, vel vidende at de aldrig har
> vundet en kamp før.

Der sættes således heller ikke startkomma mellem adverbial og ledsætning
i tilfælde som de følgende, hvor ledsætningen står forrest i
helsætningen:

> Netop som jeg stod og trak uret op, kom hun.

> Næsten hver gang man kritiserer ham, begynder han at græde.

> Indtil 30 minutter efter at tændingen er afbrudt, kan funktionen
> tilsluttes.

> Især når de får hård kritik, har de svært ved at styre sig.

#### (4) Ved tidsadverbial + ledsætning med udeladt tidskonjunktion

Ved tidsledsætninger indledt med konjunktioner og konjunktionaler som
da, når, mens, hvor sættes startkommaet umiddelbart foran ledsætningen:

> Jeg traf ham engang, da jeg var på Mallorca.

> Vi har aftalt at mødes en aften, når fjernsynet virker igen.

> Der er aldrig noget i vejen de dage, hvor vi besøger ham.

> Jeg har jo meget bedre tid nu, hvor jeg er gået på pension.

Men hvis konjunktionen eller konjunktionalet er udeladt, kan kommaet
valgfrit sættes enten lige før ledsætningen (dvs. dér hvor da mv. kunne
have stået) eller foran det forudgående adverbial:

> Jeg traf ham engang, jeg var på Mallorca *el.* Jeg traf ham, engang
> jeg var på Mallorca.

> Vi har aftalt at mødes en aften, fjernsynet virker igen *el.* Vi har
> aftalt at mødes, en aften fjernsynet virker igen

> Der er aldrig noget i vejen de dage, vi besøger ham *el.* Der er
> aldrig noget i vejen, de dage vi besøger ham

> Er der stor forskel på sidst, det skete, og så nu? *el.* Er der stor
> forskel på, sidst det skete, og så nu?

Det er således også valgfrit om man vil sætte startkomma lige før
ledsætningen eller udelade det i tilfælde som de følgende hvor
ledsætningen står forrest i helsætningen:

> En morgen, vi havde sovet længe, var ilden gået ud *el.* En morgen vi
> havde sovet længe, var ilden gået ud.

> De dage, vi besøger ham, er der aldrig noget i vejen *el.* De dage vi
> besøger ham, er der aldrig noget i vejen.

> Nu, du er derhenne, kan du så ikke tage en kop med til mig? *el.* Nu
> du er derhenne, kan du så ikke tage en kop med til mig?

> Nu, du siger det *el.* Nu du siger det.

#### (5) Ved stedsadverbial + ledsætning indledt med *hvor*

Ved stedsledsætninger indledt med hvor sættes startkommaet umiddelbart
foran ledsætningen:

> Sæt kommaet dér, hvor ledsætningen begynder.

> Du skal dreje til højre henne ved rådhuset, hvor vejen deler sig.

> Hun er født og opvokset helt derude, hvor kragerne vender.

> Her, hvor vi står, lå den gamle Østerport.

#### (6) Foran *hv*-ord mv.

##### (a) Ledsætninger med *hv*-ord

Bemærk at ledsætninger med et hv-ord (hvem, hvad, hvilken osv.) og et
eventuelt efterfølgende der begynder med hv-ordet eller den
præpositionsforbindelse der rummer hv-ordet, og at startkommaet således
skal stå foran hv-leddet:

> Jeg ved ikke, hvem der var med.

> Forstår De, hvad vi skal gøre nu?

> Han har ingen idé om, hvor mange af dem der vil med.

> Du ved sikkert, hvilke knapper man skal trykke på.

> Vi ved ikke, hvilke af de nye elever der kommer i elevrådet.

> Eleverne skal selv finde frem til, hvad der er fælles for de læste
> tekster.

> Der er ingen, der har fortalt, på hvilken måde det skal klares.

> Man har foretaget en undersøgelse af, fra hvilke lande der kommer
> flest turister.

> Hvilke oplysninger der er nødvendige, afhænger af, hvad du ansøger om.

Når sådanne ledsætninger står forrest, sættes der slutkomma der hvor
ledsætningerne slutter (som ved andre ledsætninger):

> Hvilke oplysninger der er nødvendige, afhænger af flere forhold i
> ansøgningsprocessen.

> Hvilke elever der ville bestå køreprøven, kunne vi ikke helt forudse.

> Hvem der havde sat ild til bygningen, kunne politiet ikke finde ud af.

##### (b) Ledsætninger med *som om* og *fordi*

Bemærk tilsvarende at startkommaet sættes foran -- og ikke efter --
konjunktioner som som om og fordi:

> Han lod, som om han ikke så os.

> Kampen blev aflyst, fordi den ene linjedommer ikke nåede frem.

Se også § 50.1 om startkommaets placering ved forbindelser som efter at,
i anledning af at, end at og således at.

### § 51. Tydeliggørelse

Man kan eventuelt sætte et komma hvis man derved kan tydeliggøre
meningen eller undgå mulighed for misforståelse, fx

> De besluttede(,) straks at hæve prisen.

> Tag og køb ti tulipaner(,) og en dusk persille til sovsen.

> Han hvilede sig(,) lidt inden aftenens forestilling.

> Han hvilede sig lidt(,) inden aftenens forestilling.

I almindelighed må der dog advares imod at man lader meningen af det
skrevne være afhængig af et komma. Det sikreste er altid at omskrive
sætningen så den bliver entydig:

> De besluttede sig til straks at hæve prisen.

> Lidt inden aftenens forestilling hvilede han sig.

> Inden aftenens forestilling hvilede han sig lidt.

### § 52. Kolon

#### (1) Foran ordret gengivelse

Kolon bruges efter et anførende udtryk (inkvit) der står foran ordret
gengivelse af tale, tanke, skrift osv.:

> Hun sagde: »Jeg kommer og hjælper til.«

> Jeg tænkte straks: »Nu bliver det min tur!«

> Et gammelt ordsprog lyder: Æblet falder ikke langt fra stammen.

#### (2) Foran forklaringer o.l.

Kolon bruges foran en forklaring, eksemplificering eller specificering
af et foregående ord eller udtryk:

> P.G. Holm taler om følgende emne: krisen i dansk landbrug.

> Nedenstående elever fra afgangsklassen skal til sygeeksamen
> umiddelbart efter sommerferien: Mikkel, Freja, Lucas, Ida.

> Der kan kun være én forklaring: Kassen er tom!

> Næste mødedag: torsdag den 10. november

> Adresse: Vester Voldgade 115

> Dirigent: Rafael Kubelik

> Han spurgte om vej til Tivoli: Han er nok ikke her fra byen.

> Sagen forholder sig således: Huset er for dyrt. Vi har ikke råd til at
> bo i det.

#### (3) I betydningen 'nemlig'

Der kan sættes kolon eller komma hvor tegnet kan siges at have
betydningen 'nemlig':

> P.G. Holm taler om et interessant emne: krisen i dansk landbrug.\
> P.G. Holm taler om et interessant emne, krisen i dansk landbrug.

> Der mangler endnu fire elever: Mikkel, Freja, Lucas, Ida.\
> Der mangler endnu fire elever, Mikkel, Freja, Lucas, Ida.

> Vi kan godt vente til næste mødedag: fredag den 11. oktober.\
> Vi kan godt vente til næste mødedag, fredag den 11. oktober.

> Han havde udtænkt en dristig plan: at gå på ski over indlandsisen.\
> Han havde udtænkt en dristig plan, at gå på ski over indlandsisen.

#### (4) Komma i stedet for kolon

##### (a) Foran ord og udtryk som *nemlig* og *fx/f.eks.*

Når en forklaring, eksemplificering eller specificering er tilknyttet
ved hjælp af ord som nemlig, fx/f.eks., dvs., sættes der ikke kolon, men
komma:

> P.G. Holm talte om et interessant emne, nemlig krisen i dansk
> landbrug.

> Jeg har boet i flere jyske byer, f.eks. Randers, Hobro, Nibe og Skive.

> Bogen indeholder bidrag skrevet på de centralskandinaviske sprog, dvs.
> dansk, norsk og svensk.

##### (b) Ved indskudte forklaringer o.l.

Det der står efter kolon, skal have en vis selvstændighed og i reglen
afslutte sætningen. Der kan således ikke bruges kolon ved indskudte
forklaringer, eksemplificeringer eller specificeringer; her sættes i
stedet kommaer (jf. § 47):

> Et interessant emne, krisen i dansk landbrug, blev behandlet af P.G.
> Holm.\
> *(Men: *P.G. Holm behandlede et interessant emne: krisen i dansk
> landbrug[; jf. §
> 52.3]{style="font-weight: normal; font-style: normal;"}*)*.

> I går blev et stort problem, ombygningen af biblioteket, drøftet af
> forskellige brugergrupper.\
> *(Men: *I går drøftede forskellige brugergrupper et stort problem:
> ombygningen af biblioteket[; jf. §
> 52.3]{style="font-weight: normal; font-style: normal;"}*)*.

#### (5) Mellem forfatter og værk

Kolon kan bruges mellem forfatter- eller kunstnernavn og navn på en bog,
et kunstværk e.l.:

> Hans Kirk: Fiskerne

> Søren Ulrik Thomsen: Rystet spejl. Gyldendal. København(,) 2011. 55 s.

> Carl Nielsen: Strygekvartet i g-mol, opus 13

> Arne Jacobsen: Enfamiliehuse ved Klampenborg

> Otto Bache: De sammensvorne rider fra Finderup Lade

> Kulturministeriet: Udredning om fremtidens museumslandskab.

Om brugen af store og små bogstaver efter kolon, se § 11.3.

### § 53. Spørgsmålstegn

#### (1) Efter spørgsmål

Man bruger spørgsmålstegn for at vise at ord eller sætninger er ment som
spørgsmål:

> Sover du?

> Er det i morgen han rejser? Og hvor længe bliver han så i USA?

> Vil du have kaffe? Eller øl?

> Mon hun nu mener det alvorligt?

> »Hvor bor du?« spurgte jeg.

> Hvad skal vi gøre?

> De har allerede spist?

> Med eller uden sennep og ketchup?

> Nye prisstigninger på vej?

> Allerede?

> Hvorfor?

Spørgsmålstegnet bruges kun ved direkte spørgsmål:

> Spurgte du hvor han boede?

> Ved I hvem han er?

Der skal således ikke spørgsmålstegn i fx

> Jeg spurgte hvor han boede.

> Vi ved ikke hvem han er.

#### (2) Efter udråbsspørgsmål

Efter udråbsspørgsmål (retoriske spørgsmål) kan der sættes
spørgsmålstegn eller udråbstegn:

> Hvem har ikke lyst til et par dages ekstra ferie?\
> Hvem har ikke lyst til et par dages ekstra ferie!

> Er du rigtig klog?\
> Er du rigtig klog!

#### (3) Flere spørgsmål -- fælles tegn

Er flere spørgende ord eller sætninger indholdsmæssigt tæt forbundet,
sættes der ét fælles spørgsmålstegn:

> Er det i morgen han rejser, eller er det først i overmorgen?

> Kaffe eller te?

### § 54. Udråbstegn

#### (1) Efter udråb, ordrer o.l.

Man kan bruge udråbstegn for at vise at ord eller sætninger er ment som
udråb, ordrer, opfordringer, ønsker, udtryk for forundring o.l.:

> Hallo!

> Hænderne op!

> God weekend!

> På gensyn!

> Stik mig lige skruetrækkeren!

> »Løb alt hvad I kan!« hviskede helten.

> Bare det var mig!

> At I gider!

> Den formodede puma viste sig at være en bortløbet huskat!

> Valg til januar!

> Dansk fodboldsejr på Wembley!

> Gider I lige dæmpe jer lidt!

#### (2) I indledningen til mails, breve og andre skrivelser

Udråbstegn kan bruges i indledningen til mails, breve, sms'er, taler
mv.:

> Mine damer og herrer! *el.* Mine damer og herrer

> Kære far og mor! *el.* Kære far og mor

> Hej Camilla! *el.* Hej Camilla

#### (3) Efter udråbsspørgsmål

Efter udråbsspørgsmål (retoriske spørgsmål) kan der sættes udråbstegn
eller spørgsmålstegn:

> Hvem har ikke lyst til et par dages ekstra ferie!\
> Hvem har ikke lyst til et par dages ekstra ferie?

> Er du rigtig klog!\
> Er du rigtig klog?

#### (4) Flere udråb -- fælles tegn

Er flere udråb, ordrer osv. indholdsmæssigt tæt forbundet, sættes der ét
fælles tegn:

> Ti stille, og bestil noget mere!

> God weekend og på gensyn!

### § 55. Tankestreg

Tankestreg har form som en vandret streg (typisk længere end en
bindestreg) og skrives med afstand (spatium) til de omgivende ord. (Om
tankestreg brugt som bindestreg, se § 57.9).

#### (1) Mellem helsætninger

Tankestreg kan bruges mellem helsætninger for at betegne et
indholdsmæssigt skift:

> Svigerfar var i dårligt humør. Det var derfor jeg helst ikke ville
> diskutere politik. -- I næste uge rejser vi så på ferie, og det glæder
> vi os meget til.

Her svarer tankestregen til nyt afsnit eller underafsnit.

#### (2) Dramatisk effekt

Tankestreg kan med en vis dramatisk effekt vise at det efterfølgende er
noget uventet eller overraskende:

> Han havde længe udfordret skæbnen -- og til sidst lykkedes det ham da
> også at brække en ankel.

> Pludselig -- et råb og lyden af splintret glas.

> Endelig fandt jeg mine briller; de lå -- i køleskabet.

#### (3) Ved indskud og tilføjelser

Tankestreg kan ligesom komma (§ 47) og parentes (§ 56) sættes omkring et
indskud eller foran en tilføjelse, især af selvstændig karakter:

> Hvis de siger ja -- og det håber jeg de gør! -- kan vi komme i gang
> med sagen allerede i januar.

> De stigende overskud -- der i øvrigt forventes fastholdt næste år --
> er en af årsagerne til kursstigningen.

> Luftforureningen vil blive en alvorlig trussel mod egnens dyre- og
> planteliv -- sådan som biologerne for længst har påpeget.

Ved indskud og tilføjelser kan tankestregen erstatte punktummer,
semikoloner og kommaer:

> Thomas var fraværende -- han var forkølet -- og derfor blev mødet
> aflyst *(Jf. *Thomas var fraværende; han var forkølet. Og derfor blev
> mødet aflyst*)*.

> Vi kan ikke godkende denne undskyldning -- som vi i øvrigt har hørt
> mange gange før. *(Jf. *Vi kan ikke godkende denne undskyldning, som
> vi i øvrigt har hørt mange gange før*)* .

### § 56. Parentes

#### (1) Omkring tilføjelser, forklaringer o.l.

Parentes omkring ord, orddele eller sætninger kan bruges til at betegne
tilføjelse, nærmere forklaring, specifikation eller alternativ mulighed:

> Arresø (i Nordsjælland) er Danmarks største sø.

> Træet er angrebet af blåsplint (en svampeart).

> I pausen kan der købes drikkevarer (øl, vand, kaffe).

> Bogen fås til reduceret pris (85 kr.).

> Bogen fås til reduceret pris (85 kr. (før: 150 kr.)).

> Virksomheden ophørte ved udbruddet af 2. verdenskrig (1939).

> Rejsende med hund(e).

> Ordet »hilsen« hedder i pluralis »hils(e)ner«.

> Undervisning i (amerikansk) engelsk tilbydes.

> Der betales pant for (genbrugs)flasker.

#### (2) Omkring indskud og kommentarer

Parentes kan angive den skrivendes indskud og kommentarer:

> Mødet er (heldigvis!) blevet udsat.

> Først da onkel Åge havde holdt sin tale (du ved hvor lange de er),
> kunne vi gå i gang med desserten.

> Skiltet leveres med beskyttende folie, der skal fjernes inden
> montering (se i øvrigt monteringsvejledningen).

#### (3) Parentes og andre tegn

##### (a) Punktum, semikolon og komma

Punktum, semikolon og komma sættes altid efter parentesen, og der sættes
ikke semikolon eller komma foran parentesen:

> Der var mange der var interesserede. (Således markerede oppositionen
> straks en vis interesse. Og journalisterne var naturligvis også på
> pletten).

> Der var mange der var interesserede. (Det vender jeg tilbage til).

> Thomas var fraværende (da han var forkølet); men vi gennemførte mødet
> uden ham.

> Stævnet begynder kl. 10 (præcis).

> Denne bygning (som blev opført i 1911) var oprindelig et pakhus.

> Når bygningen forlades efter kl. 18 (eller på tidspunkter hvor
> kontoret er lukket), skal porten låses.

Opremsningskomma (jf. § 46) sættes dog foran parentesen i eksempler som
Der undervises i tysk, (britisk) engelsk og fransk.

##### (b) Spørgsmålstegn og udråbstegn

Spørgsmålstegn og udråbstegn sættes efter parentesen hvis de hører til
helheden:

> Har du nogensinde været ved Arresø (i Nordsjælland)?

> Husk nu for en gangs skyld din søsters fødselsdag (25. januar)!

Hvis spørgsmålstegn og udråbstegn hører til parentesens indhold, sættes
de inde i parentesen:

> Denne gang blev årsberetningen færdig til tiden (bravo!).

> Foran huset står der en stor eg (bøg?).

#### (4) Orddeling

Ved orddeling ved linjeskift i forbindelse med parentes deles der før
begyndelsesparentes og efter slutparentes, fx

> betingelses-\
> (led)sætning

> hils(e)-\
> ner

> (genbrugs)-\
> flasker.

### § 57. Bindestreg

Bindestreg har form som en vandret streg (typisk kortere end en
tankestreg) og skrives uden afstand (spatium) til de omgivende orddele
(se dog § 57.2 og § 57.7.a).

#### (1) Ved orddeling

Bindestreg bruges ved deling af ord ved linjeskift (se § 15-17).

#### (2) I stedet for fælles orddel

Bindestreg bruges for at vise at to eller flere sammensatte eller
afledte ord har en fælles del som kun bliver nævnt én gang:

> søn- og helligdage

> øre-, næse- og halssygdomme

> haveborde og -stole

> uddannelses- og forskningsprojekter

> im- og eksport

> over- eller underskud

> såvel hjerte- som lungesygdomme

> de seks- til syvårige

> A- og B-skat

> 8.-, 9.- og 10.-klasserne.

#### (3) Forkortelser

##### (a) Sammensætninger

Der bruges bindestreg i sammensætninger med forkortelser:

> a-våben, tv-skærm, wc-papir, it-afdeling, id-kort, vm-kamp, web-tv,
> håndbold-vm, fodbold-vm-udsendelse, SoMe-medarbejder, SAS-pilot,
> KODA-afgift, NATO-øvelse, cand.mag.-uddannelsen, ph.d.-studerende,
> BT-læser, S-togsstation, e-mailadresse, EU-støtteansøgning,
> wc-papirholder, tv-seriestart, myldretids-S-tog, 3D-film *el.*
> 3d-film.

Sammensætninger med forkortelser som kan udtales som egentlige ord, og
som er skrevet med små bogstaver og evt. stort begyndelsesbogstav, kan
dog valgfrit skrives med eller uden bindestreg:

> aids-ramt *el.* aidsramt

> ufo-beretning *el.* ufoberetning

> sosu-assistent *el.* sosuassistent

> pin-kode *el.* pinkode

> Koda-afgift *el.* Kodaafgift *(men: *KODA-afgift*)*

> Nato-øvelse *el.* Natoøvelse *(men: *NATO-øvelse*)*.

Uden bindestreg skrives iland, uland og ubåd.

##### (b) Afledninger

I afledninger med tungere suffikser sættes der bindestreg mellem
forkortelsen og suffikset:

> SF-agtig, BT-agtig, tv-mæssig, pvc-holdig.

Om brug af apostrof foran suffikser, se § 6.1.

Om brug af store og små bogstaver i initialforkortelser, se § 14.2 og §
14.3.

#### (4) Taltegn, symboler, lyde mv.

Der bruges bindestreg i sammensætninger med taltegn og symboler:

> 1900-tallet, 1600-talshuse, 50-øre, 5-kantet, 6-cylindret, 25-årsnål,
> 7-trinsskalaen, 50-kroneseddel, 50-kr.-seddel, 100-meterløber,
> 100-m-løber, 20-%-rabat *el.* 20-%'s-rabat, 80'er-mode *(med
> bogstaver: *nittenhundredtallet *el.* nittenhundredetallet,
> sekstenhundredtalshuse *el.* sekstenhundredetalshuse, halvtredsøre,
> femkantet, sekscylindret, femogtyveårsnål, syvtrinsskalaen,
> halvtredskroneseddel, halvtreds-kr.-seddel, hundredmeterløber,
> tyveprocentrabat, tyveprocentsrabat, firsermode*)*.

> 18-årsfødselsdag, 2-litersflaske, 200-kilometersgrænse,
> 200-km's-grænse, 10-kronersfrimærke *(el. *18-års fødselsdag, 2-liters
> flaske, 200-kilometers grænse *(el. *200-km's grænse*)*, 10-kroners
> frimærke *(el. *10-kr.s frimærke*)*,[ jf. §
> 19.4]{style="font-weight: normal; font-style: normal;"}*)*.

> 1.-pladsen, 2.-gradsligning, 3.-behandling, Chr. X-statue *(med
> bogstaver: *førstepladsen, andengradsligning, tredjebehandling, Chr.
> den Tiende-statue*)*.

> §-nummer, §-nr., §-nummerændring, §-nr.-ændring, %-sats *(med
> bogstaver: *paragrafnummer, paragraf-nr., paragrafnummerændring,
> paragraf-nr.-ændring, procentsats*)*.

Der bruges ligeledes bindestreg i sammensætninger (og afledninger med
tungere suffikser) hvis ene led indeholder bogstaver der udtales som
bogstavnavne:

> a-lyd, a-agtig, bolle-å, enkelt-v, A-menneske, B-skål, D-vitamin,
> D-vitaminmangel, Bx-tog, V-tegn, T-shirt, T-shirtsalg, T-kryds, vej-T,
> power-to-X.

Det samme gælder ved navne på toner og tonearter:

> D-dur, Des-dur, a-mol, as-mol, C-trompet, Es-klarinet, C-durkoncert,
> es-molpræludium.

Om brug af store og små bogstaver i toner mv., se § 14.5.

Ordene iland, uland og ubåd skrives uden bindestreg.

#### (5) Sammensætninger med sidestillede led

Bindestreg bruges i sammensætninger hvis dele er betydningsmæssigt
sidestillede:

> Lolland-Falster

> marxismen-leninismen

> teknisk-merkantil sprogbrug

> det rød-hvide flag

> offentlig-privat samarbejde

> de klippe-klistrende børn

> dansk-norsk-svensk samarbejde

> køkken-alrum.

Når sådanne sammensætninger står som førsteled i en sammensætning eller
i afledninger med suffikser som fx ‑mæssig og ‑agtig, sættes endnu en
bindestreg, fx

> øre-næse-hals-læge

> årsag-virknings-forhold

> skole-hjem-samtale

> olie-eddike-dressing

> mave-tarm-kanalen

> win-win-situation

> seks-syv-tiden

> syv-syv-ordning

> bord-bænke-sæt

> læse-stave-træning

> læse-stave-mæssigt

> had-kærligheds-agtig.

Det kan i nogle tilfælde være vanskeligt at afgøre om delene i en
sammensætning først og fremmest skal opfattes som sidestillede (svarende
til en formulering med både \... og) eller som alternativer (svarende
til en formulering med enten \... eller). I sådanne tilfælde kan man
bruge bindestreg eller skråstreg (jf. § 60) afhængigt af om man lægger
hovedvægten på den ene eller den anden betydning:

> køle-varme-taske *el.* køle-/varmetaske.

#### (6) Oprindelig fremmede ordforbindelser

Bindestreg bruges i nogle få ordforbindelser af fremmed oprindelse:

> jiu-jitsu, walkie-talkie, cha-cha-cha, tete-a-tete, deja-vu.

Når sådanne ordforbindelser sættes sammen med andre ord, sættes der
endnu en bindestreg, fx

> jiu-jitsu-klub, walkie-talkie-udstyr, legetøjs-walkie-talkie,
> cha-cha-cha-melodi, tete-a-tete-sofa, deja-vu-oplevelse.

#### (7) Gruppesammensætninger og -afledninger

##### (a) Gruppesammensætninger

I sammensætninger hvis første eller sidste led er skrevet i mere end ét
ord, sættes der som hovedregel bindestreg mellem sammensætningsdelene:

> væg til væg-tæppe

> slå om-nederdel

> laissez faire-pædagogik

> science fiction-roman

> Teknik og Miljø-rådmand [(dvs. en rådmand i en afdeling med navnet
> Teknik og Miljø)]{style="font-weight: normal; font-style: normal;"}

> joint venture-aftale

> to do-liste

> tjek ind-skranke

> tro og love-erklæring

> a la carte-ret

> de facto-anerkendelse

> finans-joint venture

> kalkun-cordon bleu

> ovn-pommes frites

> § 77-eftersyn

> formel 1-racer

> top 10-liste

> type 2-diabetes.

Der kan dog desuden sættes bindestreg mellem ordene i sammensætningens
første led: væg-til-væg-tæppe, slå-om-nederdel mv. Det gælder først og
fremmest i længere og/eller mere lejlighedsvise sammensætninger:

> det-vil-jeg-ikke-finde-mig-i-attitude

> det-var-jo-det-jeg-sagde-kommentar

> bagt-i-dag-sortiment

> bilen-ud-af-byen-folk

> face-to-face-interview

> nej-tak-svar.

I sammensætninger med et flerleddet proprium som førsteled sættes der
dog kun bindestreg mellem de to overordnede sammensætningsled:

> Max Planck-Instituttet

> Carl Nielsen-symfoni

> Vestre Landsrets-dom

> Johann Sebastian Bach-biografi

> Johannes V. Jensen-påvirket

> Gorm den Gamle-historie

> New York-rejse.

Og i sammensætninger med fælles orddel sættes kun den bindestreg der
markerer den fælles del:

> mund- og klovsygebekæmpelsen

> søn- og helligdagsbetaling

> social- og sundhedsassistentuddannelsen.

I sammensætninger hvis første led består af en særskrevet forbindelse af
adjektiv + substantiv, sættes der som hovedregel bindestreg mellem
sammensætningsdelene:

> flydende krystal-skærm

> fuldt stop-skilt

> røde hunde-virus

> big bang-teori

> happy end-film

> joint venture-aftale.

Enkelte (især ældre) sammensætninger af denne type skrives dog normalt
uden bindestreg, fx

> hvid slavehandel

> kinesisk æskesystem

> rådgivende ingeniørfirma.

Sammensætninger med halv + et talord som førsteled skrives i ét ord, fx
halvtitiden (men: Klokken er halv ti). Gadenavne skrives uden bindestreg
før det sidste ord, fx Peter Bangs Vej (jf. § 12.10.c). Om stavning af
gadenavne i øvrigt, se Vejledning i retskrivning af vejnavne, Dansk
Sprognævns skrifter, 2001.

##### (b) Gruppeafledninger

I afledninger med visse suffikser hvis første led er skrevet i mere end
ét ord, sættes der bindestreg foran suffikset:

> Peter Pan-agtig

> joint venture-mæssig *(el. *joint-venture-mæssig[, jf. §
> 57.7.a]{style="font-weight: normal; font-style: normal;"}*)*

> ked af det-hed *(el. *ked-af-det-hed[, jf. §
> 57.7.a]{style="font-weight: normal; font-style: normal;"}*)*.

#### (8) Usædvanlige sammensætninger

Sammensætninger med usædvanlige eller svært læselige ord- og
bogstavsammenstød kan for tydelighedens skyld skrives med bindestreg:

> lønningsbogholderi-oplysninger

> termoluminescens-dosimeter

> lokal-lister

> bratsch-streng

> stress-symptomer

> gløgg-gilde

> ikke-sammenlignelig

> nå-siger

> iPhone-applikation

> serve-es

> tøhø-humor

> Magritte-udstilling

> Almindingen-vandring.

#### (9) I betydningen 'fra \... til'

Bindestreg kan bruges til at betegne betydningen 'fra \... til' eller
'mellem \... og' i udtryk som

> en returbillet København-Århus

> åbent mandag-fredag 9-16

> 200-300 deltagere

> Gedser-Rostock-færgen

> seks-syv-tiden.

Mellem særlig lange ord og talangivelser kan der bruges tankestreg (jf.
§ 55) i stedet for bindestreg:

> juleaften -- helligtrekongersdag

> 24\. december 1994 -- 6. januar 1995.

Se også § 60.4.

### § 58. Anførselstegn

Anførselstegn kaldes også citationstegn eller gåseøjne. Der er bl.a.
følgende anførselstegn: »\...«, "\...", ›\...‹, '\...' (se § 58.4).
Anførselstegnenes form er primært et typografisk spørgsmål. Det er
således ikke afgørende om anførselstegnene er dobbelte eller enkelte
(jf. dog § 58.4), om de er placeret oppe eller nede, eller om de vender
opad eller nedad. Hovedsagen er at de har en form der tydeligt adskiller
dem fra andre tegn i teksten, og at man i øvrigt bruger samme type
anførselstegn i hele teksten.

Man kan bruge anførselstegn for at vise at man bruger ord eller
sætninger som er hentet ud af andre tekster og sammenhænge (citater).

#### (1) Ved replikker og citater

Anførselstegn kan bruges til at markere replikker og citater:

> »Altså,« sagde lagerforvalteren, »fandt du den, eller stjal du den?«

> Det var ved den lejlighed Krag udtalte at »man har et standpunkt til
> man tager et nyt«.

> Hvorfor sagde du »straks« når du mener »om en times tid«?

> Jeg er så træt af hans energiske »godmorgen!«

> I dag bruger man normalt kun »selvom«, også i de tilfælde hvor man
> tidligere brugte »skønt«.

> Brug jokertegnene »\*« og »?« ved søgning på dele af ord og
> ordforbindelser.

Om brugen af andre tegn (punktum, komma, spørgsmålstegn, udråbstegn) i
forbindelse med anførselstegn, se § 59.4.

#### (2) Ved forbehold

Ved hjælp af anførselstegn kan man tage forbehold overfor brugen af ord
eller sætninger:

> »Salonen« viste sig at være en lille stue med kun ét vindue.

> Han har nu »studeret« i 11 år.

> Viske»læder« er rent faktisk lavet af gummi.

I forbindelse med ordet såkaldt bruges normalt ikke anførselstegn:

> Hans såkaldte studier har nu varet i 11 år. *(Men: *Hans »studier« har
> nu varet i 11 år*)*.

#### (3) Ved bogtitler o.l.

Anførselstegn kan bruges til at markere titler på bøger, skuespil, digte
mv., eller navne på institutioner, bygninger mv., især når man derved
kan undgå forveksling med navne på personer, ting eller steder, eller
når man med anførselstegnene kan afgrænse lange titler:

> Harald Herdals bog »Løg« udkom i 1935.

> »Sprog i Norden« [(navn på
> tidsskrift)]{style="font-weight: normal; font-style: normal;"} har
> eksisteret siden 1970.

> Murakamis »Norwegian wood« gjorde et stort indtryk på hende.

> I »Højt fra træets grønne top« skildres en borgerlig families
> juleaften.

> Hun er vendt tilbage til »Danmark« [(navn på
> firma)]{style="font-weight: normal; font-style: normal;"}.

> »Stærekassen« er tegnet af arkitekt Holger Jacobsen.

Om brug af store og små bogstaver ved navne på bøger mv., se § 12.9.

#### (4) Ved citat i citat

Enkelte (ufordoblede) anførselstegn kan bruges ved ord der står i en
større sammenhæng som selv er omgivet af anførselstegn:

> »Hvem har egentlig skrevet 'Højt fra træets grønne top'?« spurgte han.

#### (5) Orddeling

Ved orddeling ved linjeskift i forbindelse med anførselstegn deles der
før et begyndende anførselstegn og efter et afsluttende anførselstegn,
fx

> limfjords-\
> »kaviar«

> »pels«-\
> frakke.

### § 59. Replikgengivelse

#### (1) Repliktegn

Replikker, direkte tale, kan gengives med replikstreg (talestreg) eller
anførselstegn eller uden brug af særlige repliktegn:

> -- Er du kommet noget til? spurgte betjenten.

> »Er du kommet noget til?« spurgte betjenten.

> Er du kommet noget til? spurgte betjenten.

#### (2) Tegnsætning mellem replik og anførende udtryk (inkvit)

Der sættes kolon efter det anførende udtryk (inkvit) når det står
forrest:

> Betjenten spurgte: »Er du kommet noget til?«

Der bruges derimod ikke kolon når det anførende udtryk står inde i
replikken (eller til slut):

> -- Nej, svarede han, det tror jeg ikke.

Hvis replikken efter det anførende udtryk er en selvstændig sætning
eller et selvstændigt udtryk, sættes der punktum mellem det anførende
udtryk og den følgende replik:

> »Vi må hellere ringe efter en ambulance,« sagde betjenten. »Man ved
> aldrig.«

I andre tilfælde sættes der komma:

> »Det er altid det sikreste,« sagde betjenten, »at ringe efter en
> ambulance.«

Replikken foran det anførende udtryk afgrænses fra det anførende udtryk
med spørgsmålstegn, udråbstegn eller komma:

> -- Hvorfor? spurgte jeg.

> »Pas på!« råbte hun.

> Jeg er træt, sagde han.

Som det fremgår af eksemplerne, gælder reglerne for tegnsætning mellem
replik og anførende udtryk uanset om replikken er markeret med
replikstreger eller anførselstegn eller ikke er markeret med særlige
repliktegn.

#### (3) Replikker med replikstreger

Replikstreger har samme form som tankestreger (§ 55). Replikstreg sættes
især hvor en replik begynder på en ny linje, men kan også sættes foran
en replik der genoptages umiddelbart efter det anførende udtryk
(inkvit). I øvrigt er der ingen helt fast praksis:

> -- Vi må hellere ringe efter en ambulance, sagde betjenten. -- Man ved
> aldrig.

> Betjenten spurgte: Er du kommet noget til?\
> -- Nej, svarede hun.\
> -- Hvad skete der?\
> -- Jeg væltede bare med min cykel.\
> -- Vi må hellere ringe efter en ambulance, sagde betjenten. Man ved
> aldrig.\
> -- Jamen det er ikke nødvendigt, indvendte hun, at gøre så meget ud af
> det.\
> Betjenten: Jeg synes nu alligevel!

#### (4) Replikker med anførselstegn

Når man bruger anførselstegn, sættes de ved replikkens begyndelse og
slutning. Det anførende udtryk (inkvit) står således udenfor
anførselstegnene:

> »Det var sørens!« udbrød snedkersvenden.

Nedenstående eksempel viser replikgengivelse med anførselstegn:

> Betjenten spurgte: »Er du kommet noget til?«\
> »Nej,« svarede hun.\
> »Hvad skete der?«\
> »Jeg væltede bare med min cykel.«\
> »Vi må hellere ringe efter en ambulance,« sagde betjenten. »Man ved
> aldrig.«\
> »Jamen det er ikke nødvendigt,« indvendte hun, »at gøre så meget ud af
> det.«\
> Betjenten: »Jeg synes nu alligevel!«

Punktum og komma der afslutter en replik uden spørgsmålstegn eller
udråbstegn mv., kan valgfrit sættes foran eller efter anførselstegnet.
Det er almindeligst at sætte punktum og komma foran anførselstegnet, og
det er den placeringsmulighed der er brugt her i paragraffen og i
Retskrivningsreglerne i øvrigt. Ved replikker der står som citater inde
i en sætning, kan punktum eller komma dog kun sættes efter
anførselstegnet:

> Han siger altid »straks«, også når han mener »om en times tid«.

> Det var ved den lejlighed Krag udtalte at »man har et standpunkt til
> man tager et nyt«.

Andre tegn, fx spørgsmålstegn og udråbstegn, der afslutter en replik,
sættes altid foran anførselstegnet (se eksemplet ovenfor). Efter
replikker med sådanne tegn kan der yderligere sættes komma eller punktum
efter anførselstegnet:

> »Det var sørens!«, udbrød snedkersvenden.

> Betjenten spurgte: »Er du kommet noget til?«.

> »Vent lige lidt \...«, sagde hun.

Denne mulighed for at sætte et ekstra tegn er ikke udnyttet her i
paragraffen eller i Retskrivningsreglerne i øvrigt.

#### (5) Replikker uden repliktegn

Replikgengivelse uden brug af replikstreg eller anførselstegn
forudsætter normalt at der skiftes linje hver gang replikken skifter:

> Betjenten spurgte: Er du kommet noget til?\
> Nej, svarede hun.\
> Hvad skete der?\
> Jeg væltede bare med min cykel.\
> Vi må hellere ringe efter en ambulance, sagde betjenten. Man ved
> aldrig.\
> Jamen det er ikke nødvendigt at gøre så meget ud af det, indvendte
> hun.\
> Betjenten: Jeg synes nu alligevel!

### § 60. Skråstreg

#### (1) Ved valg mellem flere muligheder

Skråstreg kan bruges mellem to ord for at vise at der foreligger to
muligheder:

> Ved prøven skal eleven vise at han/hun har færdigheder i talregning.

> Pladsreservation ønskes/ønskes ikke.

> Hermed følger honorar for medvirken i radio/tv.

> Billet til bus/tog godtgøres ved rejsens afslutning.

> Undersøgelsen drejer sig om barnets læse- og/eller skrivefærdighed.

> køle-/varmetaske *(el. *køle-varme-taske[, jf. §
> 57.5]{style="font-weight: normal; font-style: normal;"} *)*.

#### (2) Med betydningen 'per' ('pr.')

Skråstreg kan bruges med betydningen 'per' i visse forkortelser mv.:

> km/h *el.* km/t *el.* km/t. [(kilometer per
> time)]{style="font-weight: normal; font-style: normal;"}

> m/s *el.* m/sek. [(meter per
> sekund)]{style="font-weight: normal; font-style: normal;"}

> antal elever/uge [(elever per
> uge)]{style="font-weight: normal; font-style: normal;"}

> kg/m² [(kilogram per
> kvadratmeter)]{style="font-weight: normal; font-style: normal;"}.

#### (3) I tal og datoer

Skråstreg bruges i tegnene for procent og promille og kan bruges som
brøkstreg og i datoangivelser:

> 15 %

> 75 ‰

> ¾ *(el. *34*)*

> 33⅓ *(el. *3313*)*

> 23/3-24 *el.* 23/3 24 *(el. *23.3.24*)*

> 23/3 2024 *(el. *23.3.2024 *el.* 2024-03-23*)*.

#### (4) I angivelser af tidsrum

Skråstreg kan bruges mellem to betegnelser for tidsafsnit for at angive
et tidsrum på begge sider af skellet mellem dem:

> vinteren 1942/43 *el.* 1942/1943

> årsberetning 2023/24 *el.* 2023/2024

> april/maj

> uge 43/44

> lørdag/søndag.

Se også § 57.9.

#### (5) I visse forkortelser

Skråstreg bruges i enkelte forkortelser:

> A/S *el.* a/s
> [(aktieselskab)]{style="font-weight: normal; font-style: normal;"}

> I/S *el.* i/s
> [(interessentskab)]{style="font-weight: normal; font-style: normal;"}

> K/S *el.* k/s
> [(kommanditselskab)]{style="font-weight: normal; font-style: normal;"}

> c/o [(care of)]{style="font-weight: normal; font-style: normal;"}

> t/r [(tur (og)
> retur)]{style="font-weight: normal; font-style: normal;"}

> m/k [(mand/kvinde,
> mandlig/kvindelig)]{style="font-weight: normal; font-style: normal;"}.

#### (6) Deling ved linjeskift

Ved deling ved linjeskift i forbindelse med skråstreg deles der efter
skråstregen, fx

  ------------ ------- -----------
  *lørdag/-\   *el.*   *lørdag/\
  søndag*              søndag*

  ------------ ------- -----------

§ 61-62. Tillæg {#tillæg xmlns="http://www.w3.org/1999/xhtml" h="http://www.w3.org/1999/xhtml"}
===============

### § 61. Om stavning af proprier

#### (1) Udenfor Retskrivningsordbogens område

Stavning af proprier ligger kun i begrænset omfang indenfor
Retskrivningsordbogens (og Dansk Sprognævns) område (se dog § 3 om
brugen af å og aa i stednavne og personnavne og § 11-14 om brugen af
store og små bogstaver i proprier). De almindelige
retskrivningsprincipper gælder således ikke uden videre for proprier, og
man kan ofte træffe på navne (især personnavne og navne på firmaer mv.)
hvis stavemåder afviger fra disse principper.

#### (2) Stednavne

Stavningen af danske stednavne hører under Stednavneudvalget. De danske
stednavne der er med i Retskrivningsordbogen, er derfor stavet i nøje
overensstemmelse med Stednavneudvalgets forskrifter.

I de allerfleste tilfælde er principperne for stavning af stednavne og
for stavning af sprogets almindelige ord i overensstemmelse med
hinanden. Men i enkelte tilfælde er principperne forskellige. Det er
grunden til at Retskrivningsordbogen anfører en skrivemåde som fx Ejer
Bavnehøj -- i to ord -- i stedet for skrivemåden i ét ord, Ejerbavnehøj,
der ville være i overensstemmelse med Retskrivningsreglernes principper
for hvornår man skriver i ét, og hvornår man skriver i flere ord (§
18.1).

Om de særlige problemer i forbindelse med brugen af å og aa i stednavne,
se § 3.2.

#### (3) Personnavne og firmanavne mv.

Navne på personer, firmaer, foreninger mv. bør staves på samme måde som
de pågældende selv skriver dem.

Sådanne navne staves ofte efter andre principper end dem der gælder for
sprogets almindelige ord og for stednavne. Foruden staveformer fra
fremmede sprog er der især tale om former der tidligere har været de
gængse i dansk retskrivning, og om former der ikke er i overensstemmelse
med principperne for hvornår man skriver i ét, og hvornår man skriver i
flere ord.

##### (a) Personnavne

Eksempler på personnavne:

> Niels, Nils, Clara, Klara, Åge, Aage, Meier, Meyer, Fries, Friis,
> Fris, Hoff, Schou, Schouw, Skou, Skov, Vestergård, Vestergaard,
> Westergård, Westergaard, Kierkegaard, Oehlenschläger, Honoré, René,
> Krüger, Meïr, Maës, le Fèvre, von Trier.

Om brugen af å og aa i personnavne, se også § 3.3.

##### (b) Firmanavne mv.

Eksempler på firma- og foreningsnavne mv.:

> Politiken *(men: *politikken*)*

> Kjøbenhavns Boldklub *(men: *København*)*

> Nordjydsk IT Service *(men: *nordjysk
> [og]{style="font-weight: normal; font-style: normal;"} IT-service
> *el.* it-service*)*

> Dragør Baadeværft *(men: *bådeværft*)*

> Fyens Stiftstidende *(men: *Fyn*)*

> Østerlandsk Thehus *(men: *te*)*

> Textilskolen *(men: *tekstil*)*.

### § 62. Om stavning af udråbsord og lydord

Retskrivningsordbogen indeholder kun enkelte udråbsord og lydord i deres
mest brugte staveformer, fx

> av, ha, ih, å *el.* åh, bang, bum, miav *el.* mjav, vov.

Men i øvrigt ligger stavningen af sådanne ord principielt udenfor
Retskrivningsordbogens område, og man kan således både variere de
staveformer der er nævnt i ordbogen (fx auuuv, iiih, bannng, miauuw), og
bruge udråbs- og lydord som slet ikke er med i ordbogen (fx hir-hir,
vrouuuummm, boiiiinnnng, ssh, schyy).
